#include "mbed.h"
#include "LCDTFT.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Neu42x35.h"
#include "ComicSans21x25.h"

//BusOut MyBus(PTA13,PTD5,PTD4,PTA12,PTA4,PTA5,PTC8,PTC9); // 8 bit bus on these dvices


PortOut MyPort(PortD ,0xFF); // define a port with only the lower 8 bits included - that'llbe PTD0-PTD7 making a single 8 bit port.
LCDTFT     MyLCD(PTB0,PTB1,PTB2,PTB3,PTC2,&MyPort);//LCDTFT(PinName PIN_RD,PinName PIN_WR,PinName PIN_RS,PinName PIN_CS,PinName PIN_RESET, PortOut *PORTLCD);


// next two functions need moving to the library.....
// ok - a simple sub to put in a character from the fonts defined in TFT_fonts
// c= charactetr to put
// font = pointer to font to use
// x,y locatoin of bottom lh of character, bcol = background color, fcol = foreground color
//prettyputc("m",Arial12x12,50,50,ColorBlack,ColorWhite);
void prettyputc(char c, const unsigned char *font,short xpos,short ypos,short bcol, short fcol)
{
    // Length,horz,vert,byte/vert
    int length,hor,vert,bpver; // number of bytes per character, horizontal pixels, vertical pixels and bytes per column
    //
    int x,y,i,j,k,ptr;
    short coltowrite;
    char byte,point;
    length=font[0];
    hor=font[1];
    vert=font[2];
    bpver=font[3];
    for(i=0; i<hor; i++) { // loop over columns
        for(j=0; j<vert; j++) {
            x=xpos+i;
            y=ypos+j; // NB assumes colums stored from bottom to top.... ?
            ptr=((c -32) * length+1) + 4+i*bpver+(j/8);  // pointer in font array to start of the character we want +1 to avoid the first byte that holds the char width
            byte=(char)font[ptr];
            k=j%8; // number of the pixel in this byte
            point=byte & (1<<k); // get the next bit
            if(point>0) {
                coltowrite=fcol;
            } else {
                coltowrite=bcol;
            }

            MyLCD.vLCDTFTPoint(x,y,coltowrite);

        }
    }

}




// ok now a function to use pretty putc to write strings whose bottom left corner are at xpo,ypos
// general idea is that the string is first formatted byb sprintf and the PrettyPrint is called
// bcol and fcol are the backgroun adn foreground colors
//NB max message length = 64 characters
void PrettyPrint(char *message,const unsigned char *font,short xpos,short ypos,short bcol, short fcol)
{
    short x,y,messlength,i,ptr;
    messlength=strlen(message);
    if (messlength >64) messlength=64;  // avoid writing too large a string....
    x=xpos;
    for(i=0; i<messlength; i++) {
        // x=xpos+i*(font[1]*8/10); // font[1]=char width 80% to avoid gaps
        //pointer = &font[((c -32) * offset) + 4]; // start of char bitmap
        // w = pointer[0];                          // width of actual char
        ptr=((message[i] -32) * font[0]) + 4;

        y=ypos; // will have to add cod and more to deal with different screen orientations
        //prettyputc(char c, const unsigned char *font,short xpos,short ypos,short bcol, short fcol)
        prettyputc(message[i],font,x,y,bcol,fcol);
        x=x+font[ptr]+2;
    }

}

//function to make a simple vertical progress bar
//dir is direction of fill
//0=down,1=up,2=right to left,3=left to right
void waitbar(short x,short y,short width,short height,int wtime,short emptycol,short bordercol,short fillcol,short dir)
{

    short i;
    //   MyLCD.vLCDTFTRectangle(x,y,x+width,y+height,1,emptycol); // outline empty
    MyLCD.vLCDTFTRectangle(x,y,x+width,y+height,1,emptycol); // outline empty
    MyLCD.vLCDTFTRectangle(x,y,x+width,y+height,0,bordercol); // outline empty
    if(dir<2) {
        for(i=1; i<height; i++) {
            wait((float)wtime/(float)height);
            //wait(0.1);
            if(dir==0) MyLCD.vLCDTFTLine(x+1,y+i,x+width-1,y+i,fillcol);
            if(dir==1) MyLCD.vLCDTFTLine(x+1,y+height-i,x+width-1,y+height-i,fillcol);

        }
    } else {
        for(i=1; i<width; i++) {
            wait((float)wtime/(float)height);
            //wait(0.1);

            if(dir==2) MyLCD.vLCDTFTLine(x+width-i,y+1,x+width-i,y+height-1,fillcol);
            if(dir==3) MyLCD.vLCDTFTLine(x+i,y+1,x+i,y+height-1,fillcol);
        }

    }


}



int main()
{
    int i,j,cwid;
    char message[32];
    sprintf(message,"Dive-Computer");
    while(1) {

        MyLCD.vLCDTFTInit(1);
        MyLCD.vLCDTFTFillScreen(ColorBlack);
        for(i=97; i<123; i++) {
            j=i-97;
            cwid=Arial12x12[(i-32)*Arial12x12[0]+4];
            prettyputc((char)i,Arial12x12,j*12,50,ColorBlack,ColorWhite);
            MyLCD.vLCDTFTRectangle(j*12,50,j*12+12,62,0,ColorLime);

            prettyputc((char)i,Arial12x12,j*12,80,ColorBlack,ColorWhite);
            MyLCD.vLCDTFTRectangle(j*12,80,j*12+cwid,92,0,ColorOrange);
        }

        waitbar(290,120,20,100,2,ColorBlue,ColorWhite,ColorRed,0);
        sprintf(message,"Dive-Computer");
        MyLCD.vLCDTFTFillScreen(ColorBlack);
        PrettyPrint(message,Arial28x28,10,50,ColorBlack,ColorLime);
        PrettyPrint(message,Arial24x23,10,80,ColorBlack,ColorLime);
        PrettyPrint("Message",Arial12x12,10,105,ColorBlack,ColorLime);

        sprintf(message,"width m=%d",Arial12x12[(109-32)*Arial12x12[0]+4]);

        PrettyPrint(message,Arial12x12,10,125,ColorBlack,ColorOrange);
        PrettyPrint("CCR-Ray",Neu42x35,10,175,ColorBlack,ColorCyan);
        PrettyPrint("CCR-Ray",ComicSans21x25,10,20,ColorBlack,ColorYellow);
        waitbar(290,10,20,100,2,ColorBlue,ColorWhite,ColorRed,1);


        MyLCD.vLCDTFTFillScreen(ColorWhite);
        waitbar(10,230,60,20,1,ColorBlack,ColorBlue,ColorRed,2);

    }// endwhile
} //endmain