#include "mbed.h"

DigitalOut myled(LED1);
I2C myi2c(PTE0,PTE1);
Serial pc(USBTX,USBRX);

const int ds1307=0xD0;
char data;


int bcd2int(unsigned int bcd)
{
    int pos = sizeof(bcd) * 8;
    int digit;
    int val = 0;

    do {
        pos -= 4;
        digit = (bcd >> pos) & 0xf;
        val = val * 10 + digit;
    } while (pos > 0);

    return val;
}





int main()
{
    int p;
    myi2c.frequency(100000);

    myi2c.write(ds1307,0x00,1); // tell the ds1307 we want to talk to address
    for(p=0; p<8; p++) {
        myi2c.read(ds1307,&data,1); // read one byte into data

        pc.printf("item: %d\t\tread:%d\t \n\r",p,(int)data);
        wait(0.01);
    }

    pc.printf("\n==========\n\r\nStarting the clock now\n\r");
    char cmd[2];
    cmd[0]=0;
    cmd[1]=0;
    myi2c.write(ds1307,cmd,2); // tell the ds1307 we want to talk to address 00


    while(1) {
        myled = 1;
        wait(0.8);
        myled = 0;

        myi2c.write(ds1307,0x00,1); // tell the ds1307 we want to talk to address 0
        for(p=0; p<8; p++) {
            myi2c.read(ds1307,&data,1); // read one byte into data

            pc.printf("item: %d\t\tread:%d\t VAL:%d \n\r",p,(int)data,bcd2int(data));
            wait(0.01);
        }
        wait(5);
        pc.printf("\n==========================\n\r");
    }
}

