/**
 *@section DESCRIPTION
 * ESP8266_mdm  Library
 * This sets up the ESP8266 as a server or client.
 * It detect \r\n sequence from the ESP8266 to chunk the response into lines. This then drives a state machine.
 *@section LICENSE
 * Copyright (c) 2016, Malcolm McCulloch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * @file "ESP8266_mdm.h"
 */
#ifndef ESP8266_MDM_H
#define ESP8266_MDM_H
#include <mbed.h>
#define FUNCNAME "ESP8266_mdm"
#include "defs.h"

#define BUFF_SIZE 256

/** \brief A library for the base of the solar nano grid controllers.
 *
 *   This library contains the code to drive batteries, hub etc.
 */
class ESP8266_mdm
{
public:

    // *********************
    // * Public variables: *
    // *********************

    // *********************
    // * Public hardware: *
    // *********************



    // *********************
    // * Public interrupts: *
    // *********************

    // *********************
    // * Public functions: *
    // *********************

    /**
    * Constructor:
    * @param esp A pointer to the serial connection to the esp.
    * @param server =1 for server, 0 for client
    */
    ESP8266_mdm(RawSerial *esp, int server, RawSerial *pc, PinName rstPn);
    
    /**
    * Device has received a byte
    */
    void dev_recv();

protected:

    
    // *********************
    // * Protected variables: *
    // *********************
    RawSerial *esp;        /**< The serial port */
    int server;         /**< Tells if server or not */
    RawSerial *pc;
    PinName rstPn;
    
    char **command;
    char **responseRequired;
    int maxState;
    
    volatile int state;
    volatile int ready;
    char* buffer;
    int bufferPnt;
    

    static  char* startCmnds[10];
    static  char* startResp[10];
    static  int startMaxState;

    int timeOut;

    // *********************
    // * Protected hardware: *
    // *********************
    DigitalOut* reset;
     Timer *last;

    // *********************
    // * Protected interrupts: *
    // *********************


    // *********************
    // * Protected functions: *
    // *********************



    /**
    * Loops through until state = maxState;
    */
    void doLoop(int initState);

    /**
    * Checks if pattern is in test. Returns 1 for true, 0 for no. -1 if busy. -2 ERROR
    *
    */
    int OKResponse(char *test, const char *pattern);

};

#endif