#include "mbed.h"
#include "TSISensor.h"
#define DEBUG
#define INFOMESSAGES
#define WARNMESSAGES
#define ERRMESSAGES

#define FUNCNAME "MAIN"

#ifdef NoDEBUG
#define DBG(x, ...) pc.printf("    ["FUNCNAME" : DBG] "x" <line %d>\r\n", ##__VA_ARGS__,__LINE__);
#else
#define DBG(x, ...)
#endif

#ifdef ERRMESSAGES
#define ERR(x, ...) pc.printf(" ["FUNCNAME" : ERR] "x"\r\n", ##__VA_ARGS__);
#else
#define ERR(x, ...)
#endif

#ifdef WARNMESSAGES
#define WARN(x, ...) printf("["FUNCNAME" : WARN] "x"\r\n", ##__VA_ARGS__);
#else
#define WARN(x, ...)
#endif

#ifdef INFOMESSAGES
#define INFO(x, ...) pc.printf("["FUNCNAME" : INFO] "x"\r\n", ##__VA_ARGS__);
#else
#define INFO(x, ...)
#endif

#define BUFF_SIZE 1024
// PIN DEFS NOW FOR OLD FIRMWARE VERSION OF THE KL25Z
Serial  pc(USBTX, USBRX);
//RawSerial  dev(D1, D0);
Serial  dev(PTD3,PTD2); //tx,rx
DigitalOut led1(LED1);
DigitalOut led4(LED3); // CHANGE TO LED 3
DigitalOut reset(PTA13,1);


    PwmOut led(LED_GREEN);
    TSISensor tsi;
volatile int state=0;
volatile int ready=0;

char ipAddress[20];
char macAddress[32];
char *buffer;
unsigned int bufferPnt=0;

void dev_recv()
{
    char c;

    int count = 0;
    led1 = !led1;
    if(bufferPnt==0) {
        memset(buffer,0,BUFF_SIZE);
    }
    while(dev.readable()) {
        c = (char)dev.getc();
#ifdef DEBUG
       pc.putc(c);
#endif
        buffer[bufferPnt]=c;
        bufferPnt++;
        if (bufferPnt>1000) {
            ready=1;
        }
       // if ((c==0x0a)||(c==0x0d)){
        //     ready=1;
        //     }else
        if (c==0x0a) {
            if (bufferPnt>1) {
                if (buffer[bufferPnt -2]==0x0d) {
                    ready=1;
                    break;
                }
            }
        }
        if (!dev.readable()) {
            wait_us(10);
        }
    }
}

void pc_recv()
{
    char c;
    led4 = !led4;
    while(pc.readable()) {
        c=(char)pc.getc();
        dev.putc(c);
        pc.putc(c);
        if(c==13) {
            dev.putc(10);
            pc.putc(10);
            }

    }
}

char * OKResponse(char *test, const char *pattern)
{
    char *p= strstr(test,pattern);
    if (p==NULL) {
        //   DBG("Test=<%s> Patter=<%s> NULL [p=%s]",test,pattern,p);
        return NULL;
    } else {
        //  DBG("YAY Test=<%s> Patter=<%s>  [p=%s]",test,pattern,p);
    }
    return p;
}
int main()
{
    float touch;
    buffer=(char *)calloc(BUFF_SIZE,1);
    reset=0;
    int counter=0;
    pc.baud(115200);
    dev.baud(115200);
    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
    pc.printf("Start up\n\r");
    wait(1.5);
    reset=1;
    char * resp=NULL;
    pc.printf("Here \n\r");
    while(1) {
        if (ready) {
            ready=0;
            bufferPnt=0;
            INFO("[%d],##%s##",state,buffer);
            switch (state) {
                case 0: {
                    resp=OKResponse(buffer,"WIFI GOT IP");
                    if (resp!=NULL) {
                        wait(1);
                        dev.printf("AT\r\n");
                        state++;
                    }
                    break;
                }
                case 1:
                case 2: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        dev.printf("AT\r\n");
                        state++;
                    }
                    break;
                }
                case 3: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        dev.printf("AT+RST\r\n");
                        state++;
                    }

                    break;
                }
                case 4: {
                    resp=OKResponse(buffer,"WIFI GOT IP");
                    if (resp!=NULL) {
                        dev.printf("AT+CWMODE=1\r\n");
                        state++;
                    }

                    break;
                }
                case 5: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        
                        dev.printf("AT+CWJAP=\"CWMWIFI\",\"CWM2016TT\"\r\n");
                        state++;
                    }

                    break;
                }
                case 6: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                        wait(1);
                        dev.printf("AT+CIFSR\r\n");
                        state++;
                    }

                    break;
                }
                case 7: {
                    resp=OKResponse(buffer,"+CIFSR:STAIP,");
                    if (resp!=NULL) {
                        char *strt = strtok(buffer,"\"");
                        strcpy(ipAddress,strtok(NULL,"\""));
                        strtok(NULL,"\"");
                         strcpy(macAddress,strtok(NULL,"\""));
                        INFO("mac Address = %s", macAddress);
                        INFO("IP Address = %s", ipAddress);
                          dev.printf("AT+CIPMUX=1\r\n");
                        state++;
                    }

                    break;
                }
                case 8: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                       INFO("Ready");
                       dev.printf("AT+CIPSTART=4,\"TCP\",\"192.168.1.3\",8080\r\n");
                       state++;
                    }

                     break;
                     }
                case 9: {
                    resp=OKResponse(buffer,"OK");
                    if (resp!=NULL) {
                       INFO("Ready");
                       state++; 
                       dev.printf("AT+CIPSEND=4,10\r\n");
                    }

                     break;
                     }
                    case 10: {
                    resp=OKResponse(buffer,">");
                    if (resp!=NULL) {
                       INFO("SENDING");
                       state++; 
                       touch=tsi.readPercentage();
                       dev.printf("TSI=%1.2f\n\r",touch);
                       pc.printf("   ############  tsi=%1.2f\n\r",touch);
                       //INFO("sensor=%1.2f",float)tsi.readPercentage());
                    }
                    case 11: {
                    resp=OKResponse(buffer,"SEND OK");
                    if (resp!=NULL) {
                       INFO("SEND OK");
                       state=9; 
                       //wait(2);
                       }
                       wait(1);
                       state=9; 
                    }

                     break;
                }


            }
        }
        //__WFI(); // DELETED AS IT KILLS THE KL25 RESPONSIVITY
    }
}