#include "mbed.h"
#include "debug.h"
#include "INA219.h"

#define SAMP_FREQ 

union packet_t
{
    struct
    {
        unsigned int index;
        float busVoltage;
        float shuntVoltage;
        float shuntCurrent;
    };

    char raw[];
};

int main()
{
    Adafruit_INA219 sensor(I2C_SDA, I2C_SCL);
    packet_t        packet;
    Timer           timer;
    debug           dbg;

    dbg.init( 230400 );
    sensor.begin();
    timer.start();
    
    unsigned char header[] = { 0xDE, 0xAD };

    while( 1 )
    {
        dbg.inf_pc->putc( header[0] );
        dbg.inf_pc->putc( header[1] );
        
        packet.index        = timer.read_us();
        packet.busVoltage   = sensor.getBusVoltage_V();
        packet.shuntVoltage = sensor.getShuntVoltage_mV();
        packet.shuntCurrent = sensor.getCurrent_mA();

        for( int i = 0; i < sizeof( packet ); i++ )
        {
            dbg.inf_pc->putc( packet.raw[i] );
        }

        dbg.flip();
        wait_ms( 1 );
    }
}