#ifndef DEBUG_H
#define DEBUG_H

#include "mbed.h"
#include "common.h"

enum Verbosity
{
    DBG = 0,
    MSG = 1,
    WRN = 2,
    ERR = 3
};

class debug
{
public:
    debug      (                                        ) : minimum_level( DBG ), inf_pc( NULL ), inf_bt( NULL )  {}
    void init  ( int _bdr                               ) ;
    void filter( Verbosity _min_lvl                     ) ; // select minimum output verbosity
    void out   ( Verbosity _lvl, const char* _fmt, ...  ) ;
    void tag   ( char      _tag                         ) ;
    void flip  (                                        ) ;
    char find  ( I2C * inf                              ) ;

    void srt   (                                        ) ;
    void stp   ( const char* msg                        ) ;

private:
    Verbosity   minimum_level;
    DigitalOut* led;
    DigitalOut* pin[3];
public:
    Timer*      tmr;
    Serial*     inf_pc;
    Serial*     inf_bt;
    bool        smp_pc;
    bool        fft_pc;
    bool        smp_bt;
    bool        fft_bt;
};

#endif