#include "debug.h"
#include "stdarg.h"

void debug::init( int _bdr )
{
    tmr    = new Timer();

    inf_pc = new Serial( DBG_TX, DBG_RX ); // pc debug port
    inf_bt = new Serial( BTC_TX, BTC_RX ); // bt link

    inf_pc->baud( _bdr );
    inf_bt->baud( _bdr );

    pin[0] = new DigitalOut( DBG_LA0 ); // pin used to observe events on a logic analyzer. call debug_tag( 0x1 ) and debug_tag( 0x0 ) to start and stop event marking. TODO : expand tagging to multiiple pins/bits
    pin[1] = new DigitalOut( DBG_LA1 ); //
    pin[2] = new DigitalOut( DBG_LA2 ); //
    
    led    = new DigitalOut( DBG_LED ); // heartbeat led
}

void debug::srt()
{
    tmr->reset();
    tmr->start();
}

void debug::stp( const char* msg )
{
    tmr->stop();
    inf_pc->printf( "%s completed in %d uS\n", msg, tmr->read_us() );
}

void debug::filter( Verbosity _min_lvl )
{
    minimum_level = _min_lvl;
}

void debug::out( Verbosity _lvl, const char* _fmt, ...  )
{
    if( _lvl >= minimum_level ) // filter-out all traces below the minimum verbosity level
    {
        va_list   argp;
        va_start( argp, _fmt       );
        inf_pc->printf( _fmt, argp );
        va_end(   argp             );
    }
}

void debug::tag( char tag )
{
    char msk = 0xF;
    char tmp = tag & msk;

    *pin[0] = tmp & 0x1 ? 0x1 : 0x0 ;
    *pin[1] = tmp & 0x2 ? 0x1 : 0x0 ;
    *pin[2] = tmp & 0x4 ? 0x1 : 0x0 ;
}

void debug::flip()
{
    *led = !*led;
}

char debug::find( I2C* i2c )
{
    char sla    = 0x00;
    char tmp[4] = { 0xD, 0xE, 0xA, 0xD };
    for( char a = 0x00; a < 0xFE; a += 2 )
    {
        if( i2c->write( a, tmp, 4 ) == 0 )
        {
            sla = a;
            inf_pc->printf( "0x%02x - I2C Slave Device Found at Address\n", sla );
        }
        else
        {
        //  inf_pc->printf( "0x%02x\n", a );
        }
    }
    
    return sla;
}
