#ifndef COMMON_H
#define COMMON_H

    #define  M4_SLA     0x0A >> 0   // mbed use 8-bit address, while arduino use 7-bit address; need to shift-right the 8-bit address by one in arduino
 // #define AXL_SLA     0xB4 >> 0   // ST LIS3DH accelerometer
    #define AXL_SLA     0x30 >> 0   // ST LIS3DH accelerometer
    #define PHD_SLA     0x00 >> 0   // SI photodiode

    #define DBG_LA0     PTC3
    #define DBG_LA1     PTC2
    #define DBG_LA2     PTA2
    #define DBG_LED     LED_GREEN

    #define DBG_TX      USBTX
    #define DBG_RX      USBRX
    
    #define BTC_TX      PTC17
    #define BTC_RX      PTC16
    
    #define BLE_TX      PTC4
    #define BLE_RX      PTC3
    #define BLE_INT     PTB2

    #define COM_PUP     LED_BLUE
    #define COM_SDA     PTE25
    #define COM_SCL     PTE24

    #define SEN_PUP     LED_RED
    #define SEN_SDA     I2C_SDA
    #define SEN_SCL     I2C_SCL

    union float_r
    {
        float val;
        char  raw[4];
    };

    union pair_t
    {
        struct
        {
            char    num;
            char    val;
        } reg;
    
        char raw[2];
    };

#endif