/*
** This software can be freely used, even comercially, as highlighted in the license.
** 
** Copyright 2014 GHI Electronics, LLC
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
** 
**     http://www.apache.org/licenses/LICENSE-2.0
** 
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
**/

#include "mbed.h"
#include "mBot.h"

#define MOTOR_SPEED 50
// 0.5 was too sensitive, just spun on light table
// 0.9 was too sensitive for dark tables, with 10 bit precision
#define REFLECTIVITY_READING 0.950

bool OverEdge(bool * leftOverEdge, bool * rightOverEdge, int threshold_l, int threshold_r);

        
int base_reflective_l;
int base_reflective_r;

DigitalOut LED[] = {(P1_19), (P0_19), (P0_20), (P0_2)};
static const int LED_L1 = 0;
static const int LED_L2 = 1;
static const int LED_R1 = 2;
static const int LED_R2 = 3;
static const int LED_COUNT = 4;

static int next_LED = 0;
void LEDfrontOn(){
    LED[LED_L1] = 1;
    LED[LED_R1] = 1;
};
void LEDfrontOff(){
    LED[LED_L1] = 0;
    LED[LED_R1] = 0;
};
void LEDbackOn(){
    LED[LED_L2] = 1;
    LED[LED_R2] = 1;
};
void LEDbackOff(){
    LED[LED_L2] = 0;
    LED[LED_R2] = 0;
};
void LEDsOff(){
    for (int ix = 0; ix < LED_COUNT; ix++) LED[ix] = 0;
}


DigitalOut Buzzer(P0_18); // 18 mbot, 14 lovemeter
void soundBuzzer(int Hz)
{
    int ticks = Hz/64;
    int tickCount = 0;
    float frequency = 1/(float)Hz;
    
    while(tickCount < ticks) {
        wait(frequency);
        Buzzer = true;
        wait(frequency);
        Buzzer = false;
        tickCount++;
    }
}
void soundBreaks() { 
        for (int ix = 1; ix <= 10; ix++) {       
            soundBuzzer((ix * 100) + 1500);
        }
}
void soundMotorStart() {
        for (int ix = 1; ix <= 35; ix++) {       
            soundBuzzer(ix * 100 + 800);
        } 
}
void soundForward() {     
            soundBuzzer(1000);
}

typedef DigitalIn  Button_t;
Button_t btn1(P0_1,  PullUp);
//Button_t btn2(P0_16, PullUp);


bool buttonIsUp(Button_t * button){
        return *button == 1;
};

mBot mybot;
void stopIfButtonPress(){
      if (!buttonIsUp(&btn1)){
                LEDsOff();
                 mybot.SetReflectiveSensorState(0);
                 mybot.SetMotorSpeed(0,0);
                 deepsleep();
        }
}
void startTone() {
    for (int ix = 1; ix <= 5; ix++) {
        soundBuzzer(500);
    }
}
void startUp(){
    LEDsOff();

    next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(10);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(10);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(10);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(20);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(20);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(20);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(40);
    if (next_LED >= LED_COUNT) next_LED = 0; LED[next_LED++] = 1;
    startTone(); wait_ms(40);
    if (next_LED < LED_COUNT && next_LED >= 0) LED[next_LED-1] = 0;
    startTone();
    LEDfrontOn();
    LEDbackOff();
}
int main()
{
          int overleft; 
          int overright;
          int left_temp;
          int right_temp;
          int LEDblinkCounter = 0;
          startUp();
          // add time slicing for waits
          mybot.SetMotorSpeed(MOTOR_SPEED, MOTOR_SPEED);
          wait_ms(10);
    while(1)
    {
            //wait_ms(5);
            overleft    = mybot.GetReflectiveReading(mybot.Left) > REFLECTIVITY_READING;
            overright   = mybot.GetReflectiveReading(mybot.Right)> REFLECTIVITY_READING;
            stopIfButtonPress();
            if (LEDblinkCounter++ < 8000) {
                    if (LEDblinkCounter == 4000) {
                        LEDfrontOff();
                        soundForward(); // slight wait here
                    }
            } else {              
                    LEDfrontOn();
                    LEDblinkCounter = 0;
                    soundForward(); // slight wait here
            }
            
            if( overleft || overright  )
            {   

                mybot.SetMotorSpeed(0,0);
                LEDfrontOff();
                LEDbackOn();
                //wait_us(100);
                if (overleft && overright) 
                {
                    left_temp = -30;
                    right_temp = 30;       
                } 
                else if (overleft) 
                {
                    left_temp = 60;
                    right_temp = -50;  
                } 
                else 
                {
                    left_temp = -50;
                    right_temp = 60;
                }
                
                // back straight for a safety margin and comeabout
                mybot.SetMotorSpeed(-80, -80);
                wait_ms(325);
                mybot.SetMotorSpeed(0,0);
                wait_ms(5);
                mybot.SetMotorSpeed(left_temp, right_temp);
                wait_ms(300);
                LEDbackOff();
                mybot.SetMotorSpeed(0,0);               
                LEDfrontOn();
                LEDblinkCounter = 0; 
                soundBreaks();
                mybot.SetMotorSpeed(MOTOR_SPEED,MOTOR_SPEED);

             
            }    
    }
}

