/*
** This software can be freely used, even comercially, as highlighted in the license.
** 
** Copyright 2014 GHI Electronics, LLC
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
** 
**     http://www.apache.org/licenses/LICENSE-2.0
** 
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
**/

#include "mbed.h"
#include "USBMouse.h"
#include <stdlib.h>
#include <math.h>

#define DELAY_TO_NEXT_RADIUS    (rand() % 5 + 1)
#define DELAY_TO_RESTART        (rand() % 30 + 1)

USBMouse mouse;

main()
{
    static const float DELAY_TO_START = 25.0;
    float DELAY_TO_NEXT_POINT = 0.001;
    static const int16_t RADIUS_INC = 2;
    static const int16_t ANGLE_INC = 2;
    static const int8_t NUM_CIRCLE_SIZES = 4;
    
    int16_t x = 0;
    int16_t y = 0;  
    int16_t angle = 0;
    int16_t radius = 5; // if radius is too large, OS dependent, Windows 8 it isn't visible
    int16_t recenter_radius_correction = 0;
    

    int8_t circle_count;
    
    int nextPointFrequency;
    
    // Start-up Code
    for (circle_count = 1; circle_count <= 5; circle_count++)
    {
        while (angle <= 360)
        {
            x = cos((double)angle*3.14/180.0)*5;
            y = sin((double)angle*3.14/180.0)*5;
            mouse.move(x, y);
            angle += ANGLE_INC;
            wait(.001);
        } // draw circle
            
        wait(.25);
        x = y = angle = 0; 
    } // end circle_count

    wait(DELAY_TO_START);
    
    while (true)
    {
        for (circle_count = 1; circle_count <= NUM_CIRCLE_SIZES; circle_count++)
        {
            while (angle <= 360)
            {
                x = cos((double)angle*3.14/180.0)*radius;
                y = sin((double)angle*3.14/180.0)*radius;
                mouse.move(x, y);
                recenter_radius_correction -= x;
                angle += ANGLE_INC;
                wait(DELAY_TO_NEXT_POINT);
            } // draw circle
            
            nextPointFrequency = rand() % 1000 + 1;
            
            if(nextPointFrequency < 100)
                nextPointFrequency = 100;
                
            DELAY_TO_NEXT_POINT = 1/(float)nextPointFrequency; 
            
            wait(DELAY_TO_NEXT_RADIUS);
            x = y = angle = 0; 
            radius += RADIUS_INC;
            // FIX: Change ANGLE_INCREMENT and DELAY_TO_NEXT_POINT so circle drawn relative resolution and time
            mouse.move(recenter_radius_correction,0);
            recenter_radius_correction = 0;
        } // end circle_count
        
        radius = 5;
        
        wait(DELAY_TO_RESTART);
    }
}