#include "mbed.h"

#include "DisplayN18.h"

#pragma once

class Game {    
    static const char* LOSE_1;
    static const char* LOSE_2;
    static const char* SPLASH_1;
    static const char* SPLASH_2;
    
    static const int BALL_RADIUS = 3;
    static const int PADDLE_WIDTH = 38;
    static const int PADDLE_HEIGHT = 4;
    static const int PADDLE_SPEED = 4;
    static const int BOUNCE_SOUND_TICKS = 2;
    static const int GRAPH_HEIGHT = 40;
    static const int GRAPH_SPACING = 2;
    static const char I2C_ADDR = 0x1C << 1;
    
    int ballX;
    int ballY;
    int ballSpeedX;
    int ballSpeedY;
    int paddleX;
    int pwmTicksLeft;
    int lives;
    int graphX;    
    bool mode;
    bool lastUp;
    bool lastDown;
    unsigned short colors[3];

    DigitalIn left;
    DigitalIn right;
    DigitalIn down;
    DigitalIn up;
    DigitalIn square;
    DigitalIn circle; 
    DigitalOut led1;
    DigitalOut led2;
    PwmOut pwm;
    AnalogIn ain;
    I2C i2c;
    DisplayN18 disp;
    
    void readRegisters(char address, char* buffer, int len);
    int writeRegister(char address, char value);
    void getXYZ(double& x, double& y, double& z);
    double convert(char* buffer);
    void printDouble(double value, int x, int y);
    
    void drawAxes();
    void drawPoint(int axis, double value);
    void checkGraphReset();
    
    void initialize();
    void initializeBall();
    
    void drawString(const char* str, int y);
    
    void clearPaddle();
    void drawPaddle();
    void updatePaddle();
    
    void clearBall();
    void drawBall();
    void updateBall();
    
    void checkButtons();
    void checkCollision();
    void checkPwm();
    void checkLives();
    
    public:
        Game();
        
        void showSplashScreen();
        void tick();
};