/*
** This software can be freely used, even comercially, as highlighted in the license.
** 
** Copyright 2014 GHI Electronics, LLC
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
** 
**     http://www.apache.org/licenses/LICENSE-2.0
** 
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
**/

#include "mbed.h"
#include "character_display.h"

// Outrageous Circuits PowerMate

#define TIME_BETWEEN_SAMPLES_ms 300

void led_flash();
void print_float(float value, char* units, int fraction_digits);

character_display lcd(P0_14, P0_13, P0_12, P0_11, P0_22, P0_10); // RS, E, D4-D7, LCDType=LCD16x2, BL=NC, E2=NC, LCDTCtrl=HD44780

main()
{
    Ticker blink;
    
    AnalogIn voltage(P0_23);
    AnalogIn current(P0_15);
   
    DigitalIn btn1(P0_1,PullUp);
    DigitalIn btn2(P1_19,PullUp);
    
    const int DISPLAY_VOLTAGE = 1;
    const int DISPLAY_CURRENT = 2;
    int display = 0;
    
    Timer clock;
    uint32_t start_time_ms = 0;

    blink.attach(&led_flash, 0.5);                   
    clock.start();
    
    while(1) { 
        if (btn1 == 0) {
            display = DISPLAY_VOLTAGE;
            start_time_ms = clock.read_ms(); 
            wait_ms(TIME_BETWEEN_SAMPLES_ms + 1);  // force a sample and display
        } else if (btn2 == 0){
            display = DISPLAY_CURRENT;
            start_time_ms = clock.read_ms();
            wait_ms(TIME_BETWEEN_SAMPLES_ms + 1);
        }

        if (clock.read_ms() - start_time_ms >= TIME_BETWEEN_SAMPLES_ms) {
            lcd.clear();
            switch (display){
                case DISPLAY_VOLTAGE:
                    print_float(voltage.read()*3.3*2,"V",2);
                    break;
                case DISPLAY_CURRENT:
                    print_float((current.read()*3.3)/1.1,"A",2);
                    break;
                default:
                    lcd.print("1V 2A");
                    break;
            }
            
            start_time_ms = clock.read_ms();
        }
    }
}

DigitalOut LED[]={(P0_18),(P0_19)};
uint8_t whichLED=0;

void led_flash()
{
    LED[whichLED]=1;
    whichLED = whichLED ? 0 : 1 ;
    LED[whichLED]=0;
}
 
void print_float(float value,char * suffix, int fractional_digits)
{
    char buffer[16];
    (void) sprintf(buffer,"%7.*f%1.1s", fractional_digits, value, suffix); // 8 total: 6 numeric digits, one for the decimal point, 1 for suffix
    lcd.print(buffer);
}
