/*
Copyright 2013 GHI Electronics LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#pragma once
#include "mbed.h"

class character_display{

    public:

        character_display(
             PinName  lcd_rs
            ,PinName   lcd_e
            ,PinName   lcd_d4
            ,PinName   lcd_d5
            ,PinName   lcd_d6
            ,PinName   lcd_d7
        );

        void send_nibble(unsigned char b);
        void send_byte(unsigned char b);
        void send_command(unsigned char c);
        void print(const char* string);
        void print(char character);
        void clear();
        void cursor_home();
        void set_cursor(unsigned char row, unsigned char col);

    private:

        static const uint8_t DISP_ON = 0xC;    //Turn visible LCD on
        static const uint8_t CLR_DISP = 1;      //Clear display
        static const uint8_t CUR_HOME = 2;      //Move cursor home and clear screen memory
        static const uint8_t SET_CURSOR = 0x80;   //SET_CURSOR + X : Sets cursor position to X
        static const uint8_t FUNCTION_SET = 0x20; // 001 4 bit bus, 1 line, font 5x7
        static const uint8_t MODE_SET = 0x06; // mode, direction,...
        static const uint8_t CUR_V_SHIFT = 0x14; // cursor right 
        
        
        DigitalOut  lcd_rs;
        DigitalOut  lcd_e;
        DigitalOut  lcd_d4;
        DigitalOut  lcd_d5;
        DigitalOut  lcd_d6;
        DigitalOut  lcd_d7;

};
