/*
Copyright 2013 GHI Electronics LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include "mbed.h"
#include "character_display.h"

  
character_display::character_display(     
                 PinName  a_lcd_rs
                ,PinName  a_lcd_e
                ,PinName  a_lcd_d4
                ,PinName  a_lcd_d5
                ,PinName  a_lcd_d6
                ,PinName  a_lcd_d7
        ) :
                  lcd_rs( a_lcd_rs,false)
                , lcd_e( a_lcd_e,false)
                , lcd_d4( a_lcd_d4,false)
                , lcd_d5( a_lcd_d5,false)
                , lcd_d6( a_lcd_d6,false)
                , lcd_d7( a_lcd_d7,false)
{
        lcd_rs=0;   // command mode
        wait_ms(2); // set-up time
        for (int i=0; i<3; i++) {
            send_nibble(0x3);
            wait_ms(15);
        }
        send_nibble(0x02);   // 4 bit mode
        wait_us(40);
           
        send_command(character_display::FUNCTION_SET); // characteristics of display
        clear();
        cursor_home();
        send_command(character_display::MODE_SET);
        send_command(character_display::CUR_V_SHIFT);       
        send_command(character_display::DISP_ON);
       

        wait_ms(4);
}




void character_display::send_nibble(unsigned char b)
{
    lcd_e.write(true);
    lcd_d7.write((b & 0x8) != 0);
    lcd_d6.write((b & 0x4) != 0);
    lcd_d5.write((b & 0x2) != 0);
    lcd_d4.write((b & 0x1) != 0);
    wait_us(1); 
    lcd_e.write(false); // enable data sampling
    wait_us(1);  
}

void character_display::send_byte(unsigned char b)
{
    
    send_nibble(b >> 4);
    send_nibble(b);
}

void character_display::send_command(unsigned char c)
{
    lcd_rs.write(false); //set LCD to command mode
    wait_us(1);  //for rs samplin
    send_byte(c);
    wait_us(40);
    lcd_rs.write(true); //set LCD to data mode
    wait_us(1);
}

void character_display::print(const char* string)
{
    while (*string != '\0')
        print(*(string++));
}

void character_display::print(char character)
{
    send_byte(character);
    wait_us(40);
}

void character_display::clear()
{
    send_command(character_display::CLR_DISP);
    wait_ms(10);
}

void character_display::cursor_home()
{
    send_command(character_display::CUR_HOME);
}

void character_display::set_cursor(unsigned char row, unsigned char col)
{
    char offsets[] = { 0x00, 0x40, 0x14, 0x54 };
    send_command(character_display::SET_CURSOR | offsets[row] | col);
}
