/*
** This software can be freely used, even comercially, as highlighted in the license.
** 
** Copyright 2014 GHI Electronics, LLC
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
** 
**     http://www.apache.org/licenses/LICENSE-2.0
** 
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
**/

#include "mbed.h"
#include "SoftwarePWM.h"

SPI spi(P0_21, P0_22, P1_15); // mosi, miso, sclk

//enum EYE { LEFT = 0, RIGHT = 1 };

DigitalOut Latch(P0_4);

DigitalOut PWM1(P0_13);
DigitalOut PWM2(P0_18);
DigitalOut PWM3(P0_19);
DigitalOut PWM4(P0_11);
DigitalOut PWM5(P0_16);
DigitalOut PWM6(P0_14);

//DigitalOut Eyes[] = {(P0_8), (P0_9)};// declare 2 LEDs of the eyes
SoftwarePWM LeftEye(P0_8);
SoftwarePWM RightEye(P0_9);

void WriteLED(uint64_t Shiftmap)
{
    spi.write(Shiftmap >> 40);
    spi.write(Shiftmap >> 32);
    spi.write(Shiftmap >> 24);
    spi.write(Shiftmap >> 16);
    spi.write(Shiftmap >> 8);
    spi.write(Shiftmap);
    
    Latch = true;
    Latch = false;
}

//void BlinkEye(EYE eye, bool blink)
//{
//    Eyes[eye] = blink;
//}

void Initialize()
{
    PWM1 = false;
    PWM2 = false;
    PWM3 = false;
    PWM4 = false;
    PWM5 = false;
    PWM6 = false;

    spi.format(16,0);
    spi.frequency(10 * 1000 * 1000);
}

int main()
{
    Initialize();

    uint64_t Shiftmap = 0x10101010101;
    int LED_counter = 1;

    LeftEye.Enable(25, 1000);
    RightEye.Enable(25, 1000);
    
//    bool isEyeOpen = false;

    while ( true ) {
        WriteLED(Shiftmap);
//        isEyeOpen = !isEyeOpen;
//        BlinkEye(LEFT, isEyeOpen);
//        BlinkEye(RIGHT, !isEyeOpen);

        if ( LED_counter++ < 8 ) {
            Shiftmap <<= 1;
        } else {
            Shiftmap = 0x10101010101;
            LED_counter = 1;
        }
        
        wait(.075);
    }

}