/*
** This software can be freely used, even comercially, as highlighted in the license.
** 
** Copyright 2014 GHI Electronics, LLC
** 
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
** 
**     http://www.apache.org/licenses/LICENSE-2.0
** 
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
**
**/

#include "mbed.h"
#include <stdlib.h>
#include "MMA845x.h"

PinName const SDA = P0_5;
PinName const SCL = P0_4;

#define MMA8451_I2C_ADDRESS (0x1C << 1)

//enum DieBitMask { ONE = 8, TWO = 65, THREE = 73, FOUR = 85, FIVE = 93, SIX = 119 };
enum DIE { LEFT = 0, RIGHT = 1 };

void SetDieNumber( DIE leftRight, int dieFaceNumber);
void soundBuzzer(int Hz);
void RandomRollCycle(int iteration);
void ClearLEDs();
int SetSensitivityLevel();
void ProgramSplash();
void ProgramStart();

DigitalOut LeftDieLED[] = {(P0_19), (P0_18), (P0_17), (P1_15), (P0_23), (P0_14), (P0_15)};// declare 7 LEDs on Left Die
DigitalOut RightDieLED[] = {(P0_9), (P0_8), (P0_7), (P0_21), (P0_10), (P0_22), (P0_11)};// declare 7 LEDs on Right Die
DigitalOut Buzzer(P0_13);

DigitalIn userButton1(P0_1, PullUp);
DigitalIn userButton2(P0_16);

MMA845x acc(SDA, SCL, MMA8451_I2C_ADDRESS);

int frequencyInHz = 400;
int sensitivityLevel = 1;

main()
{
    ProgramSplash();
    
    while(true)
    {
        if(!userButton2)
            SetSensitivityLevel();
        
        if(!userButton1)
            ProgramStart();
    }  
}

void SetDieNumber( DIE leftRight, int dieFaceNumber)
{
    switch (dieFaceNumber)
    {
        case 1:
            if(leftRight == LEFT)
            {
                LeftDieLED[3] = true;
            }
            else
            {
                RightDieLED[3] = true;
            }   
            break;   
        case 2:
            if(leftRight == LEFT)
            {
                LeftDieLED[0] = true;LeftDieLED[6] = true;
            }
            else
            {
                RightDieLED[0] = true;RightDieLED[6] = true;
            }
            break;   
        case 3:
            if(leftRight == LEFT)
            {
                LeftDieLED[0] = true;LeftDieLED[3] = true;LeftDieLED[6] = true;
            }
            else
            {
                RightDieLED[0] = true;RightDieLED[3] = true;RightDieLED[6] = true;
            }
            break;   
        case 4:
            if(leftRight == LEFT)
            {
                LeftDieLED[0] = true;LeftDieLED[2] = true;LeftDieLED[4] = true;LeftDieLED[6] = true;
            }
            else
            {
                RightDieLED[0] = true;RightDieLED[2] = true;RightDieLED[4] = true;RightDieLED[6] = true;
            }   
            break;   
        case 5:
            if(leftRight == LEFT)
            {
                LeftDieLED[0] = true;LeftDieLED[2] = true;LeftDieLED[3] = true;LeftDieLED[4] = true;LeftDieLED[6] = true;
            }
            else
            {
                RightDieLED[0] = true;RightDieLED[2] = true;RightDieLED[3] = true;RightDieLED[4] = true;RightDieLED[6] = true;
            }   
            break;   
        case 6:
            if(leftRight == LEFT)
            {
                LeftDieLED[0] = true;LeftDieLED[1] = true;LeftDieLED[2] = true;LeftDieLED[4] = true;LeftDieLED[5] = true;LeftDieLED[6] = true;
            }
            else
            {
                RightDieLED[0] = true;RightDieLED[1] = true;RightDieLED[2] = true;RightDieLED[4] = true;RightDieLED[5] = true;RightDieLED[6] = true;
            }   
            break;   
    }
}

void soundBuzzer(int Hz)
{
    int ticks = Hz/64;
    int tickCount = 0;
    float frequency = 1/(float)Hz;
    
    while(tickCount < ticks)
    {
        wait(frequency);
        Buzzer = true;
        wait(frequency);
        Buzzer = false;
        tickCount++;
    }
}

void RandomRollCycle(int iteration)
{
    int leftDieRoll = 0;
    int rightDieRoll = 0;

    for(int soundLoop = iteration; soundLoop > 5; soundLoop--)
    {
        leftDieRoll = rand() % 6 + 1;
        rightDieRoll = rand() % 6 + 1;

        ClearLEDs();

        SetDieNumber(LEFT, leftDieRoll);
        soundBuzzer(1000);

        SetDieNumber(RIGHT, rightDieRoll);
        soundBuzzer(500);

        wait(1/(float)soundLoop);
    }
}

void ClearLEDs()
{
    for(int y = 0; y < 7; y++)
    {
        LeftDieLED[y] = false;
        RightDieLED[y] = false;
    }
}

int SetSensitivityLevel()
{
    ClearLEDs();
    
    sensitivityLevel++;
    
    if(sensitivityLevel > 6)
        sensitivityLevel = 1;
    
    SetDieNumber(LEFT, sensitivityLevel);
    
    soundBuzzer(600);
    wait(.25);
}

void ProgramSplash()
{
    for(int x = 200; x < 1000; x+=20)
        soundBuzzer(x);
    
    SetDieNumber(LEFT, sensitivityLevel);
}

void ProgramStart()
{
    ClearLEDs();
    for(int g = 0; g < 4; g++)
    {
        soundBuzzer(1000);
        wait(0.100);
    }
    SetDieNumber(RIGHT, 6);
    SetDieNumber(LEFT, 6);
    
    
    
    int16_t zAxis = 0;
    
    int deltaX;
    int X1;
    int X2;
    
    int deltaY;
    int Y1;
    int Y2;

    int deltaZ;
    int Z1;
    int Z2;
    
    zAxis = acc.getZ();
    srand (abs(zAxis));
    
//    int inactivityCounter = 0;
    
    while(true)
    {
        X1 = acc.getX();
        Y1 = acc.getY();
        Z1 = acc.getZ();
        wait(.25);
        X2 = acc.getX();
        Y2 = acc.getY();
        Z2 = acc.getZ();
        
        deltaX = X2 - X1;
        deltaY = Y2 - Y1;
        deltaZ = Z2 - Z1;        
        
        if(abs(deltaZ) >> (sensitivityLevel + 2))
            RandomRollCycle(26);

/*       
        inactivityCounter++;
        if(inactivityCounter > 500)
        {
            inactivityCounter = 0;
            deepsleep();
        }
*/
    }

}







/*

intialize()
{
    set pins to outputs for example
    maybe initialize teh accelerometer
    AcelInit();
    }

int Getsense()
{
    int sese =1;
    while(button not pressed)
    {
        if(othe rbutton)
        {
            sense++;
            if sense > 6) sense =1;
            SetLEDs(LEFT, sense);
        }
            
    }
    return sense;
}
void main()
{
    Intialize();
    
    sense = GetSensetivity();
    
    while(1)
    {
      int x = getaccel();
      if(x >> (sense+3))
        NewDiceRandom();
      
    }
}
*/
