#include "mbed.h"     
#include "Keypad.h"  //Open Source Library for adaFruit KeyPad
                     //Modified to work with 4 row 3 col keypad
#include "CAN.h"     //Open Source Library for CAN transmitter

/*
 * Written By: 
 *   Matthew Dorshimer
 *   Ian
 *   Mohammed
 *
 * A keypad with 12 buttons (0-9,*,#) controls the Digital-Analog Conveter, 
 * DigiPot, and Analog-Digial Converter Subsystems
 * This program controls the subsystems by sending messages to the CAN Bus
 * 
 * Only one subsystem can be controlled at a time. Pressing '#' switches the active
 * subsystem. This gives each subsystem complete control of the keypad
 * 
 * Left to Do:
 *      We have not successfully read any messages. Once we can successfully 
 *      read messages, the keypad subsystem is complete
*/

char createMessage(); //Creates message based off Keytable[Index] press
void send(char* msg); //Takes the created message and sends to the CAN Bus

//DigitalOut myled(LED1);
CAN can2(p30,p29);
CAN can1(p9,p10);
char Keytable[] = { '1', '2', '3',    // r0
                    '4', '5', '6',    // r1
                    '7', '8', '9',    // r2
                    '*', '0', '#',    // r3
                 };
                 // c0   c1   c2   
 
//Runs whenever a key is pressed
//Assigns Index to the value generated by the keypad
//The value generated by the keypad is the index of the key pressed
uint32_t Index;
uint32_t cbAfterInput(uint32_t index) {
    Index = index;
    return 0;
    }
  
    
int main() {
                   // r0   r1   r2   r3   c0   c1   c2   
      Keypad keypad(p21, p22, p23, p24, p25, p26, p27);
      keypad.attach(&cbAfterInput);
      keypad.start();  // energize the keypad via c0-c3
      
      char msg = 'z';
      CANMessage recievedMessage;
    while (1) {
        __wfi(); //waits for input
        printf("Interrupted\r\n");
        wait(0.5);
        send(&msg);
        printf("Index:%d => Key:%c\r\n", Index, Keytable[Index]);
        if(can2.read(recievedMessage)) {
            printf("Message received: %s\n", recievedMessage.data);
        } //This never runs. Message can never be received for some reason
      }
  }
  
  
void send(char *str) {
    *str = createMessage();
    printf("send(%c)\n",str[0]);
    if(can1.write(CANMessage(1337, str, 1))) {
        printf("wrote successfully\n");
        } 
    }
    
//Returns a specific message to be sent to the CAN Bus
char createMessage() {
    
    char key = Keytable[Index];
    static int subsys = 0; //0 = DAC, 1 = DigiPot, 2 = ADC 
                          //static will keep the state of subsys after each call
    const char* sysName[] = {"DAC", "DigiPot", "ADC"};
    const int numOfSubsys = 3;
    
    //Cycles between subsystems when the '#' key is pressed
    if(key == '#') {
        subsys = (subsys + 1) % (numOfSubsys); //cycles from 0,1,2,0,1,2,etc
        printf("Now working with Subsystem %s\n", sysName[subsys]);
    }
    
    //Handles all message creation
    //Work with the other teams to determine what they need
    //Stick to 8 characters (8 bytes) max
    //Probably better to use a code (like hex or something)
    else {
        switch(subsys) {
            case 0:
                if(key == '2')
                    return 'a';
                else if(key == '1')
                    return 'b';
                else if(key == '3')
                    return 'c';
                else if(key == '4')
                    return 'd';
                else if(key == '5')
                    return 'e';
                else if(key == '6')
                    return 'f';
                break;
            case 1:
                if(key == '1')
                    return '1';
                else if(key == '2')
                    return '2';
                else if(key == '3')
                    return '3';
                else if(key == '4')
                    return '4';
                else if(key == '5')
                    return '5';
                break;
            case 2:
                if(key == '*')
                    return 'A';
                break;
            default:
                return '0';
                break;
            
            }
    }
}