#include "mbed.h"
#include "vt100.h"

#include "af_mgr.h"
#include "af_attributes.h"
#include "edge_mgr.h"
#include "edge_pin.h"
#include "edge_time.h"
#include "edge_reset_mgr.h"

vt100 *tty = 0 ;
uint32_t wait_tolerance = 500 ; /* 5sec */
uint32_t connect_tolerance = 60 ; /* after 60 trials, reboot */
uint32_t wait_count = 0 ;
uint32_t connect_trial_count = 0 ;

DigitalOut *led_r = 0 ;
DigitalOut *led_g = 0 ;
DigitalOut *led_b = 0 ;
// DigitalOut myled(LED1);

void doLEDs(int num)
{
    if (num & 0x01) { *led_b = 0 ; } else { *led_b = 1 ; }
    if (num & 0x02) { *led_g = 0 ; } else { *led_g = 1 ; }
    if (num & 0x04) { *led_r = 0 ; } else { *led_r = 1 ; }
}

/**
 * wait_connection
 * When gConnected == false, which is connection is lost.
 * Each 5sec check attribute ATTR_WIFI_STDY_STATE to see
 * if the connection has recovered.
 * Meantime even if connection is established communicated
 * data is invalid, so AF_SYSTEM_ASR_STATE is also
 * checked for gLinked ;
 * And in case connect_tolerance trials failed
 * try to reboot the system if it can improve the situation.
 */
void wait_connection(void)
{
    int result ;
    wait_count++ ;
    if (wait_count > wait_tolerance) {
        if (gConnected == false) {
            result = afero->getAttribute(ATTR_WIFI_STDY_STATE) ;
            if (result != afSUCCESS) {
                print_af_error(result) ;
            }
        }
        if (gLinked == false) {
            result = afero->getAttribute(AF_SYSTEM_ASR_STATE) ;
            if (result != afSUCCESS) {
                print_af_error(result) ;
            }
        }
        connect_trial_count++ ;
        if (connect_trial_count > connect_tolerance) {
            reboot_edge() ;
        }
        wait_count = 0 ;
    }
}

void init_hardware(void)
{
    tty = new vt100(PTA2, PTA1, 115200) ;
//    tty->cls() ;
    led_r = new DigitalOut(PIN_LED_R, 1) ;
    led_g = new DigitalOut(PIN_LED_G, 1) ;
    led_b = new DigitalOut(PIN_LED_B, 1) ;
}

#if 1
int main() 
{
    int led_state = 0 ;
    init_hardware() ;
    tty->printf("afLib1.3 UART test program (%s)\n", __DATE__) ;
    tty->printf("Reset Reason: ") ;
    print_reset_reason() ;
    init_aflib() ;
    tty->printf("afLib 1.3 initialized\n") ;
    doLEDs(0x04) ;
    init_timer() ;
    tty->printf("timer init done\n") ;
    while(1) {
        afero->loop() ;
        if (afero->isIdle()) {
            led_state = 0x04 ; /* red */
            if (gLinked && gConnected) {
                led_state = 0x02 ; /* green */
            } else if (gConnected) {
                led_state = 0x01 ; /* blue */
            } else {
                wait_connection() ;
            }
            doLEDs(led_state) ;
            wait_ms(100);
        }
    }
}
#else
int main() 
{
    init_hardware() ;
    tty->printf("afLib1.3 test program (%s)\n", __DATE__) ;
    init_aflib() ;
    tty->printf("afLib 1.3 initialized\n") ;
    init_timer() ;
    tty->printf("timer init done\n") ;
    while(1) {
        afero->loop() ;
        if (afero->isIdle()) {
            *led_r = ! (*led_r) ;
            wait_ms(100);
        }
    }
}
#endif
