/**
 * mbedSPI
 *
 * mbed spi class for afero afLib.
 */
#ifndef _MBEDSPI_H_
#define _MBEDSPI_H_
#include "mbed.h"
#include "afSPI.h"
#include "StatusCommand.h"
#include "afTransport.h"

#define SPI_FRAME_LEN   ((uint16_t)16)

class mbedSPI : public afTransport {
public:
    mbedSPI(PinName mosi, PinName miso, PinName sckl, PinName cs) ;

    virtual void checkForInterrupt(volatile int *interrupts_pending, bool idle);
    virtual int exchangeStatus(StatusCommand *tx, StatusCommand *rx);
    virtual int writeStatus(StatusCommand *c);
    virtual void sendBytes(char *bytes, int len);
    virtual void recvBytes(char *bytes, int len);
    virtual void sendBytesOffset(char *bytes, uint16_t *bytesToSend, uint16_t *offset);
    virtual void recvBytesOffset(char **bytes, uint16_t *bytesLen, uint16_t *bytesToRecv, uint16_t *offset);
//    virtual void recvBytesOffset(char *bytes, uint16_t *bytesLen, uint16_t *bytesToRecv, uint16_t *offset);
private:
    virtual void begin(void) ;
    virtual void beginSPI(void) ;
    virtual void endSPI(void) ;
    virtual void transfer(char *bytes,int len) ;

    SPI         _spi ;
    DigitalOut  _cs ;
} ;
    

#endif /* _MBEDSPI_H_ */