#include "mbed.h"
#include "edge_mgr.h"
#include "edge_reset_mgr.h"
#include "af_attributes.h"

#include "edge_time.h"
#include "edge_pin.h"

bool            verbos = true ;

static int error_tolerance   = 100 ;
static int loop_interval     = 100 ; // 1000 ; 
int        edge_mgr_status   = EDGE_MGR_INIT ;
char       *reset_reason_str = 0 ;

int init_edge_attribute(void)
{
    static int attr_index = 0 ;
    static int error_count = 0 ;
    int return_value = 0 ;
    int result ;
     
   
    if (error_count > error_tolerance) { // too many fails, trying reset
        reboot_edge() ;
    }
 
    return(return_value) ;
}

void edge_loop(uint32_t count_robin)
{       
    if ((count_robin % loop_interval) == 0) {
        loop_interval = 1 ;
    }
}

void   reboot_edge(void) 
{
    software_reset() ;
}