#ifndef _MBEDUART_H_
#define _MBEDUART_H_
#include "mbed.h"
#include "afTransport.h"
#include "edgeSerial.h"

#define INT_CHAR    0x32

class mbedUART : public afTransport {
public:
    mbedUART(PinName rxPin, PinName txPin, Serial *theLog) ;
    ~mbedUART(void) ;
    
    virtual void checkForInterrupt(volatile int *interrupts_pending, bool idle);
    virtual int exchangeStatus(StatusCommand *tx, StatusCommand *rx);
    virtual int writeStatus(StatusCommand *c);
    virtual void sendBytes(char *bytes, int len);
    virtual void recvBytes(char *bytes, int len);
    virtual void sendBytesOffset(char *bytes, uint16_t *bytesToSend, uint16_t *offset);
    virtual void recvBytesOffset(char **bytes, uint16_t *bytesLen, uint16_t *bytesToRecv, uint16_t *offset);
//    virtual void recvBytesOffset(char *bytes, uint16_t *bytesLen, uint16_t *bytesToRecv, uint16_t *offset);
private:
    edgeSerial *_uart ;
//    Serial *_uart ;
//    Stream *_uart ;
    Serial *_theLog ;
    uint8_t *_buf ;

    int available(void);
    char peek(void);
    void read(uint8_t *buffer, int len);
    char read(void);
    void write(uint8_t *buffer, int len);
};    
#endif /* _MBEDUART_H_ */