#include "mbed.h"
#include "afErrors.h"
#include "msg_types.h"
#include "mbedUART.h"
#include "edge_mgr.h"
#include "edge_reset_mgr.h"

#define mbedUART_BUFSIZE 300

mbedUART::mbedUART(PinName rxPin, PinName txPin, Serial *theLog) 
{
    _uart = new edgeSerial(txPin, rxPin, 9600) ;
    _buf = new uint8_t[300] ;
}

mbedUART::~mbedUART(void)
{
    if (_buf) {
        delete [] _buf ;
    }
}

int mbedUART::available(void)
{
    return (int)_uart->readable() ;
}

char mbedUART::peek(void)
{
    char c ;
    c = _uart->edge_peek() ;
//    c = _uart->getc() ;
    return c ;
    
//    return _uart->peek() ;   
}

void mbedUART::read(uint8_t *buffer, int len)
{
    _uart->edge_read(buffer, len) ;
}

char mbedUART::read(void)
{
    char c ;
    c = _uart->edge_read() ;
    return( c ) ;
}

void mbedUART::write(uint8_t *buffer, int len)
{
    _uart->edge_write(buffer, len) ;
}
        
void mbedUART::checkForInterrupt(volatile int *interrupts_pending, bool idle)
{
    char c ;
    if (_uart->readable()) {
        c = _uart->edge_peek() ;
//tty->printf("Char %02X received\n", c) ;
        if (c == INT_CHAR) {
            if (*interrupts_pending == 0) {
                c = _uart->edge_read() ;
                *interrupts_pending += 1 ; /* (*interrupts_pending)++ ; */
            } else if (idle) {
                c = _uart->edge_read() ;
            } else {
               // _theLog->printf("INT(Pending)\n") ;
            }
        } else {
            if (*interrupts_pending == 0) {
                c = _uart->edge_read() ;
            }
        }
    }
}

int mbedUART::exchangeStatus(StatusCommand *tx, StatusCommand *rx)
{
    int             result = afSUCCESS ;
    int             i ;
    uint16_t        len ;
    int             *bytes ;
    char            *rbytes ;
    int             index = 0 ;
    len = tx->getSize() ;
    bytes = new int[len] ;
    rbytes = new char[len + 1] ;
    tx->getBytes(bytes) ;
    
    for(i = 0 ; i < len ; i++ ) {
        rbytes[i] = bytes[i] ;
    }
    rbytes[len] = tx->getChecksum() ;
    sendBytes(rbytes, len + 1) ;
    
    // Skip any interrupts, that may have come in.
    do {
        recvBytes(rbytes, 1) ;
    } while(rbytes[0] == INT_CHAR) ;
            
    // Okay, we have good first char, now read the rest
    recvBytes(&rbytes[1], len) ;
        
    uint8_t cmd = bytes[index++] ;
    if (cmd != SYNC_REQUEST && cmd != SYNC_ACK) {
        tty->printf("exchangeStatus bad cmd: %02X\n", cmd) ;
        result = afERROR_INVALID_COMMAND ;
    }
    
    rx->setBytesToSend(rbytes[index + 0] | (rbytes[index + 1] << 8)) ;
    rx->setBytesToRecv(rbytes[index + 2] | (rbytes[index + 3] << 8)) ;
    rx->setChecksum(rbytes[index + 4]) ;
        
    delete [] rbytes ;
    delete [] bytes ;
    return result ;
}


int mbedUART::writeStatus(StatusCommand *c)
{
    int result = afSUCCESS ;
    uint16_t len ;
    int *bytes ;
    char *rbytes ;
    int index = 0 ;
    len = c->getSize() ;
    bytes = new int[len] ;
    rbytes = new char[len + 1] ;
    
    c->getBytes(bytes) ;
    for (int i = 0 ; i < len ; i++ ) {
        rbytes[i] = bytes[i] ;
    }
    rbytes[len] = c->getChecksum() ;
    
    sendBytes(rbytes, len + 1) ;
    
    uint8_t cmd = rbytes[index++] ;
    if (cmd != SYNC_REQUEST && cmd != SYNC_ACK) {
        tty->printf("writeStatus bad cmd: %02X\n", cmd) ;
        result = afERROR_INVALID_COMMAND ;
    }
    // c->dump() ;
    // c->dumpBytes() ;
    
    delete [] rbytes ;
    delete [] bytes ;
    
    return result ;
}

void mbedUART::sendBytes(char *bytes, int len)
{
#if 0
tty->printf("sendBytes %d: ", len) ;
for (int i = 0 ; i < len ; i++ ) { tty->printf("%02X ", bytes[i]) ; }
tty->printf("\n") ;
#endif

    _uart->edge_write((uint8_t *)bytes, len) ;
}

void mbedUART::recvBytes(char *bytes, int len)
{
    _uart->edge_read((uint8_t *)bytes, len) ;
    
#if 0
tty->printf("recvBytes %d: ", len) ;
for (int i = 0 ; i < len ; i++ ) { tty->printf("%02X ", bytes[i]) ; }
tty->printf("\n") ;
#endif
}

void mbedUART::sendBytesOffset(char *bytes, uint16_t *bytesToSend, uint16_t *offset)
{
    uint16_t len = 0 ;
    
    len = *bytesToSend ;
    
//    sendBytes(bytes, len) ;
    sendBytes(&bytes[*offset], len) ;
    
    // dumpBytes("Sending: ", len, bytes) ;
    
    *offset += len ;
    *bytesToSend -= len ;
}

void mbedUART::recvBytesOffset(char **bytes, uint16_t *bytesLen, uint16_t *bytesToRecv, uint16_t *offset)
{
    uint16_t len = 0 ;
    
    len = *bytesToRecv ;
    
    if (*offset == 0) {
        *bytesLen = *bytesToRecv ;
        *bytes = new char[*bytesLen] ;
    }
    
    char * start = *bytes + *offset ;
    
    recvBytes(start, len) ;
    
//  dumpBytes("Receiving:", len, _readBuffer) ;
#if 0
    tty->printf("Receiving: ") ;
    for (int i = 0; i < len ; i++ ) { tty->printf("%02X ", start[i]) ; } 
    tty->printf("\n") ;
#endif

    *offset += len ;
    *bytesToRecv -= len ;
}
