#include "mbed.h"
#include "vt100.h"
#include "edgeSerial.h"
#include "edge_reset_mgr.h"
extern vt100 *tty ;

edgeSerial::edgeSerial(PinName txPin, PinName rxPin, int baud) 
: Serial(txPin, rxPin, baud) 
{
    _is_peeked = false ;
    _peeked_byte = 0 ;
}
    
char edgeSerial::edge_peek(void)
{
    _peeked_byte = getc() ;
    _is_peeked = true ;
    return(  _peeked_byte ) ;
}

void edgeSerial::edge_read(uint8_t *buffer, int len)
{
    int i ;
    if (_is_peeked) {
        buffer[0] = _peeked_byte ;
        _is_peeked = false ;
#if 1
        for (i = 1 ; i < len ; i++) {
            buffer[i] = Serial::getc() ;
        }
#else
        Serial::read(&buffer[1], len) ;
#endif
    } else {
#if 1
        for (i = 0 ; i < len ; i++) {
            buffer[i] = Serial::getc() ;
        }
#else
        Serial::read(buffer, len) ;
#endif
    }     
}

char edgeSerial::edge_read(void)
{
    char c ;
// tty->printf("edge_read\n") ;
    if (_is_peeked) {
        c = _peeked_byte ;
        _is_peeked = false ;
    } else {
//    Serial::read((uint8_t*)&c, 1) ;
        c = Serial::getc() ;
    }
    return( c ) ;
}

void edgeSerial::edge_write(uint8_t *buffer, int len)
{
#if 1
    for (int i = 0 ; i < len ; i++ ) {
        Serial::write(&buffer[i], 1) ;
    }    
#else
    Serial::write(buffer, len) ;
#endif
}