#ifndef _AF_ATTRIBUTES_H_
#define _AF_ATTRIBUTES_H_

#include "mbed.h"
#include "afLib.h"

/**
 * af_attributes.h
 *
 */

#define ATTRIBUTE_TYPE_SINT8                                       2
#define ATTRIBUTE_TYPE_SINT16                                      3
#define ATTRIBUTE_TYPE_SINT32                                      4
#define ATTRIBUTE_TYPE_SINT64                                      5
#define ATTRIBUTE_TYPE_BOOLEAN                                     1
#define ATTRIBUTE_TYPE_UTF8S                                      20
#define ATTRIBUTE_TYPE_BYTES                                      21
#define ATTRIBUTE_TYPE_FIXED_15_16                                 6

#define afSUCCESS                    0    // Operation completed successfully
#define afERROR_NO_SUCH_ATTRIBUTE   -1    // Request was made for unknown attribute id
#define afERROR_BUSY                -2    // Request already in progress, try again
#define afERROR_INVALID_COMMAND     -3    // Command could not be parsed
#define afERROR_QUEUE_OVERFLOW      -4    // Queue is full
#define afERROR_QUEUE_UNDERFLOW     -5    // Queue is empty
#define afERROR_INVALID_PARAM       -6    // Bad input parameter

#define AF_SYSTEM_COMMAND            65012
#define AF_SYSTEM_ASR_STATE          65013
#define AF_SYSTEM_LINKED_TIMESTAMP   65015

#define MODULE_STATE_REBOOTED                 0
#define MODULE_STATE_LINKED                   1
#define MODULE_STATE_UPDATING                 2
#define MOUDLE_STATE_UPDATE_READY             3

#define MODULE_COMMAND_NONE                   0
#define MODULE_COMMAND_REBOOT                 1

#define ATTR_SOFTWARE_RESET          666
#define ATTR_MCU_RESET_REASON        999

#define ATTR_LED                 1024
#define ATTR_IO0                 1025
#define ATTR_IO1                 1026
#define ATTR_IO2                 1028
#define ATTR_BUTTON              1030
#define ATTR_IO3                 1031

#define ATTR_BOOT_LOADER_VER     2001
#define ATTR_BLE_STACK_VER       2002
#define ATTR_FW_APP_VER          2003
#define ATTR_DEVICE_DESC         2004
#define ATTR_WIFI_VER            2006

#define ATTR_OFFLINE_SCHED      59001
#define ATTR_SECURITY_ENABLED   60000
#define ATTR_UTC_OFFSET         65001
#define ATTR_CONFIGURES_SSID    65004
#define ATTR_WIFI_BARS          65005
#define ATTR_WIFI_STDY_STATE    65006

#define ATTR_COMMAND            65012
#define ATTR_ASR_STATE          65013
#define ATTR_LOW_BATTERY        65014
#define ATTR_LINKED_TIMESTAMP   65015
#define ATTR_ATTR_ACK           65018
#define ATTR_REBOOT_REASON      65019
#define ATTR_BLE_COMMS          65020
#define ATTR_MCU_INTERFACE      65021

#define DISPLAY_MODE_OFF        0
#define DISPLAY_MODE_GAS        1
#define DISPLAY_MODE_SUMMARY    2
#define DISPLAY_MODE_CHART      3

typedef struct {
    uint16_t id ;
    char *description ;
    int attribute_type ;
    int size ;
} af_attribute_type ;

/**
 * get_af_attr
 * @param id attribute id value to look up
 * @returns index of the attribute in the af_attribute_type af_attr[]
 */
int get_af_attr(uint16_t id) ;

/**
 * print_af_error
 * @param resultCode return value from afLib function(s)
 */
void print_af_error(int resultCode) ;

/**
 * Callback that allows ASR to request an MCU attribute be changed. 
 * You should define this function in your MCU firmware to perform application-specific actions 
 * your code must take (e.g., updating the state of the hardware), 
 * in light of the attribute value change.
*/
bool attributeChangeRequest(
    const uint8_t   requestId, 
    const uint16_t  attributeId,
    const uint16_t  valueLen,
    const uint8_t   *value
) ;

/*
 * Application callback that allows afLib to notify that an attribute has changed. 
 * This method will be called in response to a getAttribute call from the application 
 * and whenever a ASR module attribute changes.
 */
void attributeUpdatedReport(
    const uint8_t   requestId,
    const uint16_t  attributeId,
    const uint16_t  valueLen,
    const uint8_t   *value
) ;

extern afLib *afero ; 
#endif /* _AF_ATTRIBUTES_H */