/*
 * File description 
 *
 */

#ifndef _VEML6040_H_
#define _VEML6040_H_

#include "mbed.h"

/**
 * RGBW Color Sensor with I2C Interface
 * I2C 7bit address: 0x10
 *
 */

class VEML6040 
{
public:
 /**
 *  constructor
 *
 * @param i2c Pointer of the I2C object
 * @param addr address of the I2C peripheral
 */
 VEML6040(I2C *i2c, int addr) ;
 
 ~VEML6040() ;

 /*
  * some member functions here (yet to be written)
  */
/**
 * get Red
 * @param none
 * @returns float value of Red
 */
float getR(void) ; // return float value of Red

/**
 * get Green
 * @param none
 * @returns float value of Green
 */
float getG(void) ; // return float value of Green

/**
 * get Blue
 * @param none
 * @returns float value of Blue
 */
float getB(void) ; // return float value of Blue

/**
 * get White
 * @param none
 * @returns float value of White
 */
float getW(void) ; // return float value of White

/**
 * get CCT(McCAMY FORMULA) value X
 * @param none
 * @returns float CCT value X
 */
float getX(void) ; // return float value of X

/** 
 * get CCT(McCAMY FOMULA) value Y
 * @param none
 * @returns float CCT value Y
 */
float getY(void) ; // return float value of Y

/**
 * get CCT(McCAMY FOMULA) value Z
 * @param none
 * @returns float CCT value Z
 */
float getZ(void) ; // return float value of Z

/**
 * get CIE1931 X
 * @param none
 * @returns float CIE1931 X
 */
float getCIEX(void) ; // return float value of CIE1931_x

/**
 * get CIE1931 Y
 * @param none
 * @returns float CIE1931 Y
 */
float getCIEY(void) ; // return float value of CIE1931_y

void getCOLORConf(uint8_t *colorconf) ;
void setCOLORConf(uint8_t colorconf) ;
// void getX(uint8_t *X) ;
// void getY(uint8_t *Y) ;
// void getZ(uint8_t *Z) ;
/**
 * get raw Red data
 * @param uint16_t *rdata 
 * @returns i2c status 0: success non-0: failure
 */
int getRData(uint16_t *rdata) ;

/**
 * get raw Green data
 * @param uint16_t *gdata
 * @returns i2c status 0: success non-0: failure
 */
int getGData(uint16_t *gdata) ;

/**
 * get raw Blue data
 * @param uint16_t *bdata
 * @returns i2c status 0: success non-0: failure
 */
int getBData(uint16_t *bdata) ;

/**
 * get raw White data
 * @param uint16_t *wdata
 * @returns i2c status 0: success non-0: failure
 */
int getWData(uint16_t *wdata) ;

// void getCCTiData(uint16_t *cctidata) ;
/**
 * get CCTi data for CCT (EMPIRICAL APPROACH)
 * @param none
 * @returns float CCTi data
 */ 
float getCCTiData(void) ;
// void getCCTData(uint16_t *cctdata) ;

/**
 * get CCT data (EMPIRICAL APPROACH)
 * @param none
 * @returns float CCD data
 */
float getCCTData(void) ;
//  void cmdRead(uint8_t cmd, uint8_t *data, uint8_t numdata = 2) ;
//  void cmdWrite(uint8_t cmd, uint8_t *data, uint8_t numdata = 2) ;
  
private:
  I2C *p_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
} ;
#endif /* _VEML6040_H_ */
