#include "mbed.h"
#include "SMTC502AT.h"

#if 0
class SMTC502AT {
public:
    SMTC502AT(AnlogIn *ain) ;
    ~SMTC502AT(void) ;
    float getTemp(void) ;
private:
    AnalogIn *_ain ;
    float _r0 ;
    float _r1 ;
    float _b ;
    float _t0 ;
} ;
#endif

SMTC502AT::SMTC502AT(AnalogIn *ain, float R0, float R1, float B, float T0) 
{
    _ain = ain ;
    _r0 = R0 ;
    _r1 = R1 ;
    _b  = B ;
    _t0 = T0 ;
}

SMTC502AT::~SMTC502AT(void)
{
    if (_ain) {
        delete _ain ;
    }
}

float SMTC502AT::getTemp(void)
{
    float result = 0.0 ;
    float f, raw, rr1, t ;
    if (_ain) {
        f = _ain->read() ;
        raw = f * 3.3 ;
        rr1 = _r1 * raw / (3.3 - raw) ;
        t = 1.0 / (log(rr1 / _r0) / _b + (1/_t0)) ;
        result = t - 273.15 ;
    }
    return( result ) ;
}
        