/**
 * MMA8451Q 3-Axis, 14-bit/8-bit Digital Accelerometer
 */
#ifndef _MMA8451Q_H_
#define _MMA8451Q_H_

#include "mbed.h"

class MMA8451Q {
public:
  /**
  * MMA8451Q constructor
  *
  * @param i2c pointer to the I2C object
  * @param addr 7bit addr of the I2C peripheral
  */
  MMA8451Q(I2C *i2c, int addr);

  /**
  * MMA8451Q destructor
  */
  ~MMA8451Q();
  
  int     getAllRawData(int16_t data[]) ;
  int     getAllData(float value[]) ;
  int16_t getRawData(uint8_t addr) ;
  int16_t getRawX(void) ;
  int16_t getRawY(void) ;
  int16_t getRawZ(void) ;
  
  float getAccX(void) ;
  float getAccY(void) ;
  float getAccZ(void) ;
  
private:
  I2C *p_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
} ;

#endif /* _MMA8451Q_H_ */