#ifndef _LM75B_H_
#define _LM75B_H_

#include "mbed.h"

/**
* NXP LM75B Digital temperature sensor and thermal watchdog
*
* @code
#include "mbed.h"
#include "LM75B.h"
#define LM75B_I2C_ADDRESS (0x48)

#if defined (TARGET_KL25Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL46Z)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_K64F)
#define PIN_SCL  PTE24
#define PIN_SDA  PTE25
#elif defined (TARGET_K22F)
#define PIN_SCL  PTE1
#define PIN_SDA  PTE0
#elif defined (TARGET_KL05Z)
#define PIN_SCL  PTB3
#define PIN_SDA  PTB4
#elif defined (TARGET_NUCLEO_F411RE)
#define PIN_SCL  PB_8
#define PIN_SDA  PB_9
#else
 #error TARGET NOT DEFINED
#endif

int main() {
    int8_t itemp = 0 ;
    float ftemp = 0.0 ;
    LM75B lm75b(PIN_SDA, PIN_SCL, LM75B_I2C_ADDRESS) ;
    
    while(1) {
        itemp = lm75b.temp() ;
        lm75b.getTemp(&ftemp) ;
        printf("Temp = %d C degree,  %.3f C degree\n", itemp, ftemp) ;
        wait(1) ;
    }
}
* @endcode
*/
class LM75B
{
public:
  /**
  * LM75B constructor
  *
  * @param i2c pointer to the I2C object
  * @param addr addr of the I2C peripheral
  */
  LM75B(I2C *i2c, int addr);

  /**
  * LM75B destructor
  */
  ~LM75B();

  /**
  * get temperature as one byte (signed)
  */
  int8_t temp(void) ;
  
  /**
   * get temperature as 11 bit (float)
   */
  void getTemp(float *temp) ;
  
  /**
   * get configuration register
   */
  uint8_t getConfig(uint8_t ptr_byte) ;
  
  /**
   * set configuration register
   */
  int setConfig(uint8_t ptr_byte, uint8_t config_data) ;

private:
  I2C *p_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);

};

#endif