#include "mbed.h"
#include "LM75B.h"

/* Register list */
#define PTR_CONF    0x01
#define PTR_TEMP    0x00
#define PTR_TOS     0x03
#define PTR_THYST   0x02

/* Configuration register */
/* B[7:5] : Reserved */
/* B[4:3] : OS_F_QUE[1:0] OS fault queue value */
#define CONFIG_QUE_1    0x00
#define CONFIG_QUE_2    (0x01 << 3)
#define CONFIG_QUE_4    (0x10 << 3)
#define CONFIG_QUE_6    (0x11 << 3) 
/* B[2] : OS_POL  0 = OS active LOW,  1 = OS active HIGH */
#define CONFIG_OS_POL_L 0x00
#define CONFIG_OS_POL_H (0x01 << 2)
/* B[1] : OS_COMP_INT 0 = OS comparator, 1 = OS interrupt */
#define CONFIG_OS_COMP  0x00
#define CONFIG_OS_INT   (0x01 << 1)
/* B[0] : SHUTDOWN    0 = normal, 1 = shutdown */
#define CONFIG_NORMARL  0x00
#define CONFIG_SHUTDOWN 0x01

/* Temperature register */
/* D[15:5] = 11 bit data 0.125 * temp data */
/* D[4:0] : reserved */

/* Tos register */
/* D[15:7] = 9 bit data */
/* D[6:0] : reserved */

/* Thyst register */
/* D[15:7] = 9 ibt data */
/* D[6:0] : reserved */

LM75B::LM75B(I2C *i2c, int addr) : m_addr(addr<<1) {
    p_i2c = i2c ;
    p_i2c->frequency(100000); /* 100kHz */
    // activate the peripheral
}

LM75B::~LM75B() { }

int8_t LM75B::temp(void)
{
    char t[1] = { 0x00 } ;
    int8_t temp ;
    p_i2c->write(m_addr, t, 1, true) ;
    p_i2c->read(m_addr, t, 1) ;
    temp = (int8_t)t[0] ;
    return( temp ) ;
}

void LM75B::getTemp(float *temp)
{
    char t[2] ;
    int16_t iTemp = 0 ;
    p_i2c->read(m_addr, t, 2) ; /* read MSB, LSB */
    iTemp = (t[0] << 8) | t[1] ;
    iTemp >>= 5 ;
    *temp = 0.125 * iTemp ;
}

uint8_t LM75B::getConfig(uint8_t ptr_byte) 
{
    int result ;
    char config ;
    p_i2c->write(m_addr, (char*)(&ptr_byte), 1, true) ;
    p_i2c->read(m_addr, &config, 1) ;
    return( config ) ;
}

int LM75B::setConfig(uint8_t ptr_byte, uint8_t config_data) 
{
    int result ;
    char t[2] ;
    t[0] = ptr_byte ;
    t[1] = config_data ;
    result = p_i2c->write(m_addr, t, 2, true) ;
    return( result ) ;
}

int LM75B::readRegs(int addr, uint8_t * data, int len) 
{
    int result ;
    char t[1] = {addr};
    result = p_i2c->write(m_addr, t, 1, true);
    if (result == 0) {
        result = p_i2c->read(m_addr, (char *)data, len);
    }
    return( result ) ;
}

int LM75B::writeRegs(uint8_t * data, int len) {
    int result ;
    result = p_i2c->write(m_addr, (char *)data, len);
}