#include "mbed.h"
#include "vt100.h"
#include "afLib.h"
#include "af_mgr.h"
#include "edge_mgr.h"
#include "edge_time.h"
#include "edge_reset_mgr.h"

vt100   *tty = 0 ;

void init_hardware(void)
{
    int result ;
    init_sensors() ;
    init_aflib() ;
    init_timer() ;
    while(true) {
        for (int i = 0 ; i < 10 ; i++ ) {
            afero->loop() ;
        }
        if ((gLinkedState == true) && afero->isIdle()) {
            result = init_edge_attribute() ;
            if (result == 0) {
                break ;
            }
        }
        wait_ms(10) ;
    }
}

// main() runs in its own thread in the OS
int main() {
    static uint32_t count_robin = 0 ;

    tty = new vt100() ;
    tty->cls() ;
    printf("Afero test program (ver. %s) started\n", __DATE__) ;   
    printf("=== Reset Reson ===\n") ;
    print_reset_reason() ;
    printf("===================\n") ;

    init_hardware() ;

    while (true) {
        count_robin++ ;
        afero->loop() ;
        if ((gLinkedState == true) && afero->isIdle()) {
            edge_loop(count_robin) ;
        }
        wait_ms(10) ;
    }
}
