#ifndef _SO1602A_H_
#define _SO1602A_H_
#include "mbed.h"

/***********************************
 * SO1602A
 * Liquid Crystal Display Module
 * Sunlike Display Technology co.
 *
 * OLED White & Black
 * I2C Interface
 ***********************************/

class SO1602A
{
public:
  /**
  * SO1602A constructor
  *
  * @param *i2c address of I2C object
  * @param addr addr of the I2C peripheral
  */
  SO1602A(I2C *i2c, int addr);

  /**
  * SO1602A destructor
  */
  ~SO1602A();
  
  void test(void) ;
  void contrast_max(void) ;
  void init_oled(void) ;
  void writeData(uint8_t data) ;
  void writeCommand(uint8_t command) ;
  void cls(void) ;
  void returnHome(void) ;
  void displayOn(void) ;
  void displayOff(void) ;
  void displayCTRL(uint8_t data) ;
  void locate(int x, int y) ;
  void putStr(char *str) ;

private:
  I2C *p_i2c;
  int m_addr;
  int readRegs(int addr, uint8_t * data, int len);
  int writeRegs(uint8_t * data, int len);
};

#endif /* _SO1602A_H_ */