#include "mbed.h"
#include "SO1602A.h"

#define BIT_DISPLAY_CTRL  0x08
#define BIT_DISPLAY_ON    0x04
#define BIT_CURSOR_ON     0x02
#define BIT_BLINKING_ON   0x01

#define CLEAR_DISPLAY 0x01
#define RETURN_HOME   0x02

void SO1602A::test(void)
{
    char test_str[] = "I2C OLED WHITE1234" ;
    int i ;
    for (i = 0 ; test_str[i] != 0 ; i++ ) {
        writeData(test_str[i]) ;
    }
    writeCommand(0x20+0x80) ; // line 2 column 1
    for (i = 0 ; i < 10 ; i++ ) {
        writeData(i+0xB1) ;
    }
    contrast_max() ;
    writeCommand(0x0F) ;
    wait_ms(10) ;
}

SO1602A::SO1602A(I2C *i2c, int addr) : m_addr(addr<<1) {
    p_i2c = i2c ;
    init_oled() ;
}

SO1602A::~SO1602A(void)
{
}

void SO1602A::locate(int x, int y)
{
    uint8_t data ;
    if (x < 0) x = 0 ;
    if (x > 0xf) x = 0xf ;
    if (y < 0) y = 0 ;
    if (y > 1) y = 1 ;
    data = 0x80 + x ;
    if (y == 1) {
        data |= 0x20 ;
    }
    writeCommand(data) ;
}

void SO1602A::putStr(char *str)
{
    int i ;
    for (i = 0 ; str[i] ; i++ ) {
        writeData(str[i]) ;
    }
    wait_ms(10) ;
}

void SO1602A::writeData(uint8_t data) 
{
    int result ;

    uint8_t t[2] ;
    t[0] = 0x40 ;
    t[1] = data ;
    writeRegs(t, 2) ;
    
    wait_ms(1) ;
}

void SO1602A::writeCommand(uint8_t command) 
{
    int result ;

    uint8_t t[2] ;
    t[0] = 0 ;
    t[1] = command ;
    writeRegs(t, 2) ;
    wait_ms(10) ;
}

void SO1602A::contrast_max(void) 
{
    writeCommand(0x2A) ; // RE=1
    writeCommand(0x79) ; // SD=1
    writeCommand(0x81) ; // set Contrast
    writeCommand(0xFF) ; // brightness MAX
    writeCommand(0x78) ; // SD=0 
    writeCommand(0x28) ; // 2C = High char 28 = Normal
    wait_ms(100) ;    
}

void SO1602A::init_oled(void) 
{
    wait_ms(100) ;
    writeCommand(CLEAR_DISPLAY) ; // Clear Display
    wait_ms(20) ;
    writeCommand(RETURN_HOME) ; // Return Home
    wait_ms(2) ;
//    writeCommand( 0x0F ) ;
    writeCommand( 0x0C ) ; 
    wait_ms(2) ;
    writeCommand(CLEAR_DISPLAY) ; 
    wait_ms(100) ;
}

void SO1602A::cls(void) 
{
    writeCommand(CLEAR_DISPLAY) ;
    wait_ms(20) ;
}

void SO1602A::returnHome(void) 
{
    writeCommand(RETURN_HOME) ;
    wait_ms(2) ;
}

void SO1602A::displayCTRL(uint8_t data) 
{
    writeCommand(BIT_DISPLAY_CTRL | data) ;
    wait_ms(2) ;
}

void SO1602A::SO1602A::displayOff(void) 
{
    writeCommand(BIT_DISPLAY_CTRL) ;
    wait_ms(2) ;
}

int SO1602A::readRegs(int addr, uint8_t * data, int len) 
{
    int result ;
    char t[1] = {addr};
    result = p_i2c->write(m_addr, t, 1, true);
    if (result == 0) {
        result = p_i2c->read(m_addr, (char *)data, len);
    }
    return( result ) ;
}

int SO1602A::writeRegs(uint8_t * data, int len) {
    int result ;
    result = p_i2c->write(m_addr, (char *)data, len);
    return(result) ;
}
