#ifndef _EDGE_TEMP_H_
#define _EDGE_TEMP_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "LM75B.h"
#include "SMTC502AT.h"

class edge_temp : public edge_sensor {
public:
    edge_temp(LM75B *temp1, SMTC502AT *temp2, SMTC502AT *temp3, LM75B *temp4) ;
    ~edge_temp(void) ;
    virtual void    reset(void) ;
    virtual void    prepare(void) ;
    virtual void    sample(void) ;
    virtual int     deliver(void) ;
    virtual void    send_config(void) ; /* send config data to cloud */
    virtual void    recv_config(void) ; /* receive config data from cloud */
    
    int accum(void) ;
    void clear_value(void) ;
    float get_value(void) ;

private:
    LM75B       *_temp1 ;
    SMTC502AT   *_temp2 ;
    SMTC502AT   *_temp3 ;
    LM75B       *_temp4 ;
    float       _ftemp[4] ;
} ;

extern float *current_temp ;
#endif /* _EDGE_TEMP_H_ */