#include "mbed.h"
#include "LM75B.h"
#include "edge_sensor.h"
#include "edge_temp.h"

float *current_temp = 0 ;

edge_temp::edge_temp(LM75B *temp1, SMTC502AT *temp2, SMTC502AT *temp3, LM75B *temp4) 
{
    _temp1 = temp1 ;
    _temp2 = temp2 ;
    _temp3 = temp3 ;
    _temp4 = temp4 ;
    _ftemp[0] = _ftemp[1] = _ftemp[2] = _ftemp[3] = 0.0 ;
    _interval = 30 ;
    current_temp = &_ftemp[1] ; /* use before for current temp */
}

edge_temp::~edge_temp(void)
{
    if (_temp1) {
        delete _temp1 ;
    }
    if (_temp2) {
        delete _temp2 ;
    }
    if (_temp3) {
        delete _temp3 ;
    }
    if (_temp4) {
        delete _temp4 ;
    }
}

void    edge_temp::reset(void) 
{
}

void    edge_temp::prepare(void) 
{
}

void    edge_temp::sample(void) 
{
    if (_temp1) {
        _temp1->getTemp(&_ftemp[0]) ;
    }
    if (_temp2) {
        _ftemp[1] = _temp2->getTemp() ;
    }
    if (_temp3) {
        _ftemp[2] = _temp3->getTemp() ;
    }
    if (_temp4) {
        _temp4->getTemp(&_ftemp[3]) ;
    }
    _sampled_time = edge_time ;
}

int    edge_temp::deliver(void) 
{
    int result ;
    char timestr[16] ;
    
    print_time() ;
    printf(" temp: ") ;
    if (_temp1) {
        printf("LM75B1 = %.2f ", _ftemp[0]) ;
    } 
    if (_temp2) {
        printf("before = %.2f ", _ftemp[1]) ;
    }
    if (_temp3) {
        printf("after = %.2f ", _ftemp[2]) ;
    }
    if (_temp4) {
        printf("LM75B2 = %.2f ", _ftemp[3]) ;
    }
    printf("\n") ;
    time2seq(_sampled_time, timestr) ;
    sprintf(_str_buf,
    "{\"DEVICE\":\"TEMP04\",\"VAL_1\":\"%.1f\",\"VAL_2\":\"%.1f\",\"VAL_3\":\"%.1f\",\"S\":\"%s\",\"E\":\"%d\"}",
        _ftemp[0], _ftemp[1], _ftemp[2], timestr, _error_count) ;
    result = afero->setAttribute(1, _str_buf) ;
    return( result == afSUCCESS ) ;
}

void edge_temp::send_config(void)
{
}

void edge_temp::recv_config(void)
{
}
