#ifndef _EDGE_SENSOR_H_
#define _EDGE_SENSOR_H_
#include "edge_time.h"
#include "afLib.h"
#include "af_mgr.h"

class edge_sensor {
public:
    edge_sensor() ;
    ~edge_sensor() ;
    virtual void    reset(void) ;
    virtual void    enable(void) ;
    virtual void    disable(void) ;
    virtual bool    isEnabled(void) ;

    virtual void    prepare(void) ;
    virtual void    sample(void) ;
    virtual int     deliver(void) ;
    virtual void    toJson(char *buf) ;

    void            setInterval(uint16_t interval) ;
    uint16_t        getInterval(void) ;
    int             getStatus(void) ;
    int             advanceStatus(void) ;
    virtual int     runStateMachine(void) ;
protected:
    uint16_t        _id ;
    bool            _enable ;
    uint32_t        _interval ;
    int             _status ;
    int             _error_count ;
    int             _prev_status ;
    uint32_t        _end_interval ;
    uint32_t        _sampled_time ;
    char            _str_buf[256] ;
} ;

/* may be, we had better use enum here */
#define EDGE_SENSOR_INACTIVE    0
#define EDGE_SENSOR_WAIT        1
#define EDGE_SENSOR_READY       2
#define EDGE_SENSOR_PREPARED    3
#define EDGE_SENSOR_SAMPLED     4
#define EDGE_SENSOR_DELIVERD    5


#endif /* _EDGE_SENSOR_H_ */