#include "mbed.h"
#include "vt100.h"
#include "edge_time.h"
#include "edge_sensor.h"

extern vt100 *tty ;
static uint16_t id = 0 ;

edge_sensor::edge_sensor()
{
    _interval = 0 ;
    _prev_status = EDGE_SENSOR_INACTIVE ;
    _status = EDGE_SENSOR_INACTIVE ;
    _id = id++ ;
    _enable = false ;
    _error_count = 0 ;
}

edge_sensor::~edge_sensor()
{
}

void edge_sensor::reset(void)
{
    _status = EDGE_SENSOR_INACTIVE ;
}

void edge_sensor::enable(void) 
{
    _enable = true ;
}

void edge_sensor::disable(void) 
{
    _enable = false ;
}

bool edge_sensor::isEnabled(void)
{
    return( _enable ) ;
}

void edge_sensor::prepare(void)
{
//    printf("Sensor %d prepare for sample\n", _id) ;
}

void edge_sensor::sample(void)
{
//    printf("Sensor %d sample\n", _id) ;
}

int edge_sensor::deliver(void) 
{
//  printf("Sensor %d data delivered\n", _id) ;
    /* usually return( result == afSUCCESS ) ; */
    return 1 ; /* return non zero for success */
}

void edge_sensor::toJson(char *buf)
{
    sprintf(buf, "EDGE_SENSOR%d is not a real sensor", _id) ;
}

void edge_sensor::setInterval(uint16_t interval) 
{
    _interval = interval ;
}

uint16_t edge_sensor::getInterval(void) 
{
    return( _interval ) ;
}

int edge_sensor::getStatus(void)
{
    return( _status ) ;
}

/*
#define EDGE_SENSOR_INACTIVE    0
#define EDGE_SENSOR_WAIT        1
#define EDGE_SENSOR_READY       2
#define EDGE_SENSOR_PREPARED    3
#define EDGE_SENSOR_SAMPLED     4
#define EDGE_SENSOR_DELIVERD    5
*/

int edge_sensor::runStateMachine(void)
{
    int result ;
    switch(_status) {
    case EDGE_SENSOR_INACTIVE: /* inactive */
        if (isEnabled()) {
            _status = EDGE_SENSOR_WAIT ;
        }
        _prev_status = EDGE_SENSOR_INACTIVE ;
        break ;
    case EDGE_SENSOR_WAIT: /* wait for interval time expires */
        if (_prev_status != _status) {
            _end_interval = edge_time + _interval ;
        }
        _prev_status = EDGE_SENSOR_WAIT ;
        if (edge_time >= _end_interval) {
            _status = EDGE_SENSOR_READY ;
        }
        break ;
    case EDGE_SENSOR_READY: /* prepare to sample */
        sample() ;
        _prev_status = EDGE_SENSOR_READY ;
        _status = EDGE_SENSOR_SAMPLED ;
        break ;
    case EDGE_SENSOR_SAMPLED: /* data is ready, wait for delivery */
        if (_prev_status != EDGE_SENSOR_SAMPLED) {
            _error_count = 0 ;
        }
        result = deliver() ;
        if (result) {
            _status = EDGE_SENSOR_INACTIVE ;
        } else {
            _error_count++ ;
        }
        _prev_status = EDGE_SENSOR_SAMPLED ;
 
        break ;
    }
    return(_status) ;
}
    
