#ifndef _EDGE_PRESSURE_H_
#define _EDGE_PRESSURE_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "PSE530.h"


class edge_pressure : public edge_sensor {
public:
    edge_pressure(PSE530 *pse) ;
    ~edge_pressure(void) ;
    virtual void    reset(void) ;
    virtual void    prepare(void) ;
    virtual void    sample(void) ;
    virtual int     deliver(void) ;
    virtual void    send_config(void) ; /* send config data to cloud */
    virtual void    recv_config(void) ; /* receive config data from cloud */
    
    float get_value(void) ;
    void  set_thr_mode(int mode)    { _thr_mode = mode ; }
    int   get_thr_mode(void)        { return _thr_mode ; }
    void  set_thr_high(int16_t thr_high) ;
    float get_thr_high(float expected) ;
    void  set_thr_low(int16_t thr_low) ;
    float get_thr_low(float expected)  ;
    
private:
    PSE530  *_pse ;
    float   _value ;
    float   _thr_high ;
    float   _thr_low ;
    int     _thr_mode ;
} ;

float temp2expected(float temp) ;
extern float *current_temp ;

#endif /* _EDGE_PRESSURE_H_ */