#ifndef _EDGE_COLOR_H_
#define _EDGE_COLOR_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "VEML6040.h"

class edge_color : public edge_sensor {
public:
    edge_color(VEML6040 *sensor, PwmOut *led[], uint16_t *pwm) ;
    ~edge_color(void) ;
    virtual void        reset(void) ;
    virtual void        prepare(void) ;
    virtual void        sample(void) ;
    virtual int         deliver(void) ;
    
    void        calibrate(uint16_t target[], uint16_t result[], int num_ave) ;
    void        getAveColor(uint16_t v[], int num_ave) ;
    void        getRGB(uint16_t v[]) ;
    uint8_t     getConfig(void) { return _sensor_config ; }
    void        setConfig(uint8_t config) { _sensor_config = config ; }
    uint16_t    get_pwm_period(void) { return _pwm_period ; }   
    void        set_pwm_period(uint16_t period) { _pwm_period = period ; }
    uint16_t    get_pwm_target(void) { return _pwm_target ; }
    void        set_pwm_target(uint16_t target) { _pwm_target = target ; }
    uint16_t    getR(void) { return _value[0] ; }
    uint16_t    getG(void) { return _value[1] ; }
    uint16_t    getB(void) { return _value[2] ; }
    uint16_t    getPwmR(void) { return _pwm[0] ; }
    uint16_t    getPwmG(void) { return _pwm[1] ; }
    uint16_t    getPwmB(void) { return _pwm[2] ; }
    void        setLEDs(uint16_t led_value[]) ;
    void        setLEDs(uint16_t r, uint16_t g, uint16_t b) ;
    
protected:
    VEML6040    *_sensor ;
    uint8_t     _sensor_config ;
    PwmOut      *_led[3] ;
    uint16_t    _pwm_period ;
    uint16_t    _pwm_target ;
    uint16_t    _value[3] ; /* r, g, b */
    uint16_t    _pwm[3] ;   /* r, g, b */
    uint16_t    _probe ; /* probing value for calibration */
} ;

extern uint16_t        color0_pwm[3] ;
extern uint16_t        color1_pwm[3] ;
extern uint16_t        color0_target[3] ;
extern uint16_t        color1_target[3] ;

#endif /* _EDGE_COLOR_H_ */