#ifndef _EDGE_ACCEL_H_
#define _EDGE_ACCEL_H_
#include "mbed.h"
#include "edge_sensor.h"
#include "MMA8451Q.h"

class edge_accel : public edge_sensor {
public:
    edge_accel(MMA8451Q *accel) ;
    ~edge_accel(void) ;
    virtual void    reset(void) ;
    virtual void    prepare(void) ;
    virtual void    sample(void) ;
    virtual int     deliver(void) ;
    virtual void    send_config(void) ; /* send config data to cloud */
    virtual void    recv_config(void) ; /* receive config data from cloud */
        
    int accum(void) ;
    void clear_value(void) ;
    float get_value(void) ;

private:
    MMA8451Q *_accel ;
    int32_t _sample_count ;
    int32_t _accumulation ;
    int16_t _prev_x ;
    int16_t _prev_y ;
    int16_t _prev_z ;
} ;

#endif /* _EDGE_ACCEL_H_ */