#include "mbed.h"
#include "afLib.h"
#include "edge_sensor.h"
#include "edge_accel.h"
#include "MMA8451Q.h"

edge_accel::edge_accel(MMA8451Q *accel) : edge_sensor() 
{
    _accel = accel ;
    _sample_count = 0 ;
    _accumulation = 0 ;
    _prev_x = 0 ;
    _prev_y = 0 ;
    _prev_z = 0 ;
    
    _interval = 10 ;
}

edge_accel::~edge_accel(void)
{
    delete _accel ;
}

void    edge_accel::reset(void) 
{
    clear_value() ;
    edge_sensor::reset() ;
}

void    edge_accel::prepare(void) 
{
//    printf("accel prepare\n") ;
}

void    edge_accel::sample(void) 
{
//    printf("accel sample\n") ;
}

int    edge_accel::deliver(void) 
{
    int result ;
    float value ;
    char timestr[16] ;
    print_time(_sampled_time) ;
    value = get_value() ;
    printf(" accel: %.3f [%d samples]\n", value, _sample_count) ;
    time2seq(_sampled_time, timestr) ;
    sprintf(_str_buf,
        "{\"DEVICE\":\"ACCEL\",\"PN\":\"MMA8451Q\",\"VAL_X\":\"%.3f\",\"VAL_Y\":\"0\",\"VAL_Z\":\"0\",\"UNIT\":\"g\",\"S\":\"%s\",\"E\":\"%d\"}",
        value, timestr, _error_count) ;
    result = afero->setAttribute(1, _str_buf) ;
    if (result == afSUCCESS) {
        clear_value() ;
    }
    return( result == afSUCCESS ) ;
}

int edge_accel::accum(void)
{
    int16_t value[3] ;

    if (_enable) {
       _accel->getAllRawData(value) ;
            
        _sample_count++ ;
    
        _accumulation +=
              abs(_prev_x - value[0])
            + abs(_prev_y - value[1])
            + abs(_prev_z - value[2]) ;        
    
        _prev_x = value[0] ;
        _prev_y = value[1] ;
        _prev_z = value[2] ;
    }
        
    return( _sample_count ) ;
}

void edge_accel::clear_value(void)
{
    _sample_count = 0 ;
    _accumulation = 0 ;
    _prev_x = 0 ;
    _prev_y = 0 ;
    _prev_z = 0 ;
}

float edge_accel::get_value(void)
{
    float result = 0.0 ;
    if (_sample_count > 0) {
        result = (float)_accumulation / (float)_sample_count ;
    }
    _sampled_time = edge_time ;
    return( result / 4096.0 ) ;
}

void edge_accel::send_config(void)
{
    afero->setAttributeBool(100, true) ; /* accel present */
    afero->setAttributeBool(101, true) ; /* accel enable */
}

void edge_accel::recv_config(void)
{
}
        
        