#include "mbed.h"
#include "vt100.h"
#include "afSPI.h"
#include "mbedSPI.h"

/*
class mbedSPI : public afSPI {
public:
    mbedSPI(PinName mosi, PinName miso, PinName sckl, PinName cs) ;
    virtual void begin() ;
    virtual void beginSPI() ;
    virtual void endSPI() ;
    virtual void transfer(char *bytes,int len) ;
private:
    SPI         _spi ;
    DigitalOut  _cs ;
} ;
*/

mbedSPI::mbedSPI(PinName mosi, PinName miso, PinName sckl, PinName cs) :
    _spi(mosi, miso, sckl), _cs(cs, 1)
{
    _spi.format(8, 0) ;
    _spi.frequency(1000000) ; /* 1MHz */
#if defined (TARGET_KL25Z) || defined (TARGET_TEENSY3_1)
    #ifndef SPI0_C1
        #define SPI0_C1 (*(uint8_t *)0x40076000)
    #endif
    SPI0_C1 |= 0x01 ; /* LSB First */
#endif
}

void mbedSPI::begin(void)
{
}

void mbedSPI::beginSPI()
{
//    printf("+") ; fflush(stdout) ;
    _cs = 0 ;
    wait_us(1) ;
}

void mbedSPI::endSPI()
{
    _cs = 1 ;
    wait_us(1) ;
//    printf("-") ; fflush(stdout) ;
}

void mbedSPI::transfer(char *bytes, int len)
{
    int i ;
    for (i = 0 ; i < len ; i++ ) {
        bytes[i] = _spi.write(bytes[i]) ;
    }
}

