#ifndef _AF_ATTRIBUTES_H_
#define _AF_ATTRIBUTES_H_
#include "mbed.h"
#include "afLib.h"

#define ATTRIBUTE_TYPE_SINT8                                       2
#define ATTRIBUTE_TYPE_SINT16                                      3
#define ATTRIBUTE_TYPE_SINT32                                      4
#define ATTRIBUTE_TYPE_SINT64                                      5
#define ATTRIBUTE_TYPE_BOOLEAN                                     1
#define ATTRIBUTE_TYPE_UTF8S                                      20
#define ATTRIBUTE_TYPE_BYTES                                      21
#define ATTRIBUTE_TYPE_FIXED_15_16                                 6

#define afSUCCESS                    0    // Operation completed successfully
#define afERROR_NO_SUCH_ATTRIBUTE   -1    // Request was made for unknown attribute id
#define afERROR_BUSY                -2    // Request already in progress, try again
#define afERROR_INVALID_COMMAND     -3    // Command could not be parsed
#define afERROR_QUEUE_OVERFLOW      -4    // Queue is full
#define afERROR_QUEUE_UNDERFLOW     -5    // Queue is empty
#define afERROR_INVALID_PARAM       -6    // Bad input parameter

#define AF_SYSTEM_COMMAND            65012
#define AF_SYSTEM_ASR_STATE          65013
#define AF_SYSTEM_LINKED_TIMESTAMP   65015

#define MODULE_STATE_REBOOTED                 0
#define MODULE_STATE_LINKED                   1
#define MODULE_STATE_UPDATING                 2
#define MOUDLE_STATE_UPDATE_READY             3

#define MODULE_COMMAND_NONE                   0
#define MODULE_COMMAND_REBOOT                 1

#define ATTR_SENSE_VAL               1
#define ATTR_ACCEL_PRESENT           100
#define ATTR_ACCEL_ENABLE            101
#define ATTR_ACCEL_INTERVAL          102 /* 100ms */
#define ATTR_ACCEL_VALUE             103

#define ATTR_COLOR0_PRESENT          200
#define ATTR_COLOR0_ENABLE           201
#define ATTR_COLOR0_INTERVAL         202
#define ATTR_COLOR0_TRIGMODE         203
#define ATTR_COLOR0_ITIME            204
#define ATTR_COLOR0_CALIBRATE        205
#define ATTR_COLOR0_PWM_R            206
#define ATTR_COLOR0_PWM_G            207
#define ATTR_COLOR0_PWM_B            208
#define ATTR_COLOR0_PWM_PERIOD       209
#define ATTR_COLOR0_PWM_TARGET       210
#define ATTR_COLOR0_R_VALUE          211
#define ATTR_COLOR0_G_VALUE          212
#define ATTR_COLOR0_B_VALUE          213

#define ATTR_COLOR1_PRESENT          220
#define ATTR_COLOR1_ENABLE           221
#define ATTR_COLOR1_INTERVAL         222
#define ATTR_COLOR1_TRIGMODE         223
#define ATTR_COLOR1_ITIME            224
#define ATTR_COLOR1_CALIBRATE        225
#define ATTR_COLOR1_PWM_R            226
#define ATTR_COLOR1_PWM_G            227
#define ATTR_COLOR1_PWM_B            228
#define ATTR_COLOR1_PWM_PERIOD       229
#define ATTR_COLOR1_PWM_TARGET       230
#define ATTR_COLOR1_R_VALUE          231
#define ATTR_COLOR1_G_VALUE          232
#define ATTR_COLOR1_B_VALUE          233

/* temperature sensor LM75B with color0 */
#define ATTR_TEMP0_PRESENT           300
#define ATTR_TEMP0_ENABLE            301
#define ATTR_TEMP0_INTERVAL          302
#define ATTR_TEMP0_VALUE             303

/* temperature sensor AT502-11 (before) */
#define ATTR_TEMP1_PRESENT           310
#define ATTR_TEMP1_ENABLE            311
#define ATTR_TEMP1_INTERVAL          312
#define ATTR_TEMP1_VALUE             313

/* temperature sensor AT502-11 (after) */
#define ATTR_TEMP2_PRESENT           320
#define ATTR_TEMP2_ENABLE            321
#define ATTR_TEMP2_INTERVAL          322
#define ATTR_TEMP2_VALUE             323

/* temperature sensor LM75B with color1 */
#define ATTR_TEMP3_PRESENT           330
#define ATTR_TEMP3_ENABLE            331
#define ATTR_TEMP3_INTERVAL          332
#define ATTR_TEMP3_VALUE             333

/* gas pressure sensor */
#define ATTR_GAS_PRESENT            400
#define ATTR_GAS_ENABLE             401
#define ATTR_GAS_INTERVAL           402
#define ATTR_GAS_VALUE              403
#define ATTR_GAS_THR_MODE           404
#define ATTR_GAS_THR_HIGH           405
#define ATTR_GAS_THR_LOW            406

/* current trans sensor */
#define ATTR_CURRENT_PRESENT         500
#define ATTR_CURRENT_ENABLE          501
#define ATTR_CURRENT_INTERVAL        502
#define ATTR_CURRENT_VALUE           503

#define ATTR_SOFTWARE_RESET          666
#define ATTR_MCU_RESET_REASON        999

#define ATTR_LED                 1024
#define ATTR_IO0                 1025
#define ATTR_IO1                 1026
#define ATTR_IO2                 1028
#define ATTR_BUTTON              1030
#define ATTR_IO3                 1031

#define ATTR_BOOT_LOADER_VER     2001
#define ATTR_BLE_STACK_VER       2002
#define ATTR_FW_APP_VER          2003
#define ATTR_DEVICE_DESC         2004
#define ATTR_WIFI_VER            2006

#define ATTR_OFFLINE_SCHED      59001
#define ATTR_SECURITY_ENABLED   60000
#define ATTR_UTC_OFFSET         65001
#define ATTR_CONFIGURES_SSID    65004
#define ATTR_WIFI_BARS          65005
#define ATTR_WIFI_STDY_STATE    65006

#define ATTR_COMMAND            65012
#define ATTR_ASR_STATE          65013
#define ATTR_LOW_BATTERY        65014
#define ATTR_LINKED_TIMESTAMP   65015
#define ATTR_ATTR_ACK           65018
#define ATTR_REBOOT_REASON      65019
#define ATTR_BLE_COMMS          65020
#define ATTR_MCU_INTERFACE      65021

typedef struct {
    uint16_t id ;
    char *description ;
    int attribute_type ;
    int size ;
} af_attribute_type ;

int get_af_attr(uint16_t id) ;
void print_af_error(int resultCode) ;

/*
 * Callback that allows ASR to request an MCU attribute be changed. 
 * You should define this function in your MCU firmware to perform application-specific actions 
 * your code must take (e.g., updating the state of the hardware), 
 * in light of the attribute value change.
*/
void attributeChangeRequest(
    const uint8_t   requestId, 
    const uint16_t  attributeId,
    const uint16_t  valueLen,
    const uint8_t   *value
) ;

/*
 * Application callback that allows afLib to notify that an attribute has changed. 
 * This method will be called in response to a getAttribute call from the application 
 * and whenever a ASR module attribute changes.
 */
void attributeUpdatedReport(
    const uint8_t   requestId,
    const uint16_t  attributeId,
    const uint16_t  valueLen,
    const uint8_t   *value
) ;

extern char *reset_reason_str ;
extern afLib *afero ; 
// extern iafLib *afero ;
#endif /* _AF_ATTRIBUTES_H */