#ifndef _WATCH_DOG_WRAPPER_HPP_
#define _WATCH_DOG_WRAPPER_HPP_

#if defined(TARGET_KL25Z)

#include "mbed.h"
#include "DebugIO.hpp"

/**
 * COP (Watch Dog Info)
 * SIM_COPC   0x4004_8100
 * bit[3:2] COPT
 *  00 : COP disabled
 *  01 : COP timeout after 2^5 LPO cycles or 2^13 bus clock cycles
 *  10 : COP timeout after 2^8 LPO cycles or 2^16 bus clock cycles
 *  11 : COP timeout after 2^10 LPO (1024ms) cycles or 2^18 bus clock cycles
 * bit[1]   COPCLKS 
 *   0 : Internal 1kHz clock is source to COP
 *   1 : Bus clock source to COP
 * bit[0]   COPW
 *   0 : Normal mode
 *   1 : Windowed mode
 *
 * SIM_SRVCOP 0x4004_8104
 * bit[7:0] Service COP Register
 *  Write 0x55 and then 0xAA (in that order) to reset COP timeout counter.
 *
 * NOTE: SIM->COPC register can be written only ONCE after each reset.
 */
 
 #include "Singletoned.hpp"
 
class WatchDogWrapper :
    public Singletoned<WatchDogWrapper>
{
    void (WatchDogWrapper::*pReset)();
    void empty();
    void _reset();
    friend class Signletoned;
public:
    WatchDogWrapper();
    void kick_the_bucket();
    void reset();
};

#endif //TARGET_KL25Z

#endif //_WATCH_DOG_WRAPPER_HPP_