#ifndef _ULTRA_SIMPLE_QUEUE_
#define _ULTRA_SIMPLE_QUEUE_

//#include <string.h>

template<typename T> class USQueue
{
    public: enum QSIZE
    {
        QSIZE_8 = 8,
        QSIZE_16 = 16,
        QSIZE_32 = 32,
        QSIZE_64 = 64
    };
    private: T *q;
    private: unsigned char eqi;
    private: unsigned char dqi;
    private: T init_val;
    private: QSIZE _size;
    public: USQueue(T init_val, QSIZE _size = QSIZE_64) : eqi(0), dqi(0)
    {
        q = new T[_size];
        for(unsigned int i=0; i<_size; ++i)
        {
            q[i] = init_val;
        };
        this->init_val = init_val;
        this->_size = _size;
    }
    public: ~USQueue()
    {
        delete[] q;
        q = NULL;
    }
    public: inline void enq(T t)
    {
        q[eqi] = t;
        ++eqi;
        eqi = eqi&(_size-1);
    }
    private: inline T _deq()
    {
        T r = q[dqi];
        q[dqi] = init_val;
        ++dqi;
        dqi = dqi&(_size-1);
        return r;
    }
    public: inline T deq()
    {
        T ret = init_val;
        for(unsigned int i=0; i<_size; ++i)
        {
            if( (ret = _deq()) != init_val )
            {
                break;
            }
        }
        return ret;
    }
    public: inline T pkq(T unavailable)
    {
        T ret = unavailable;
        unsigned char _dqi = dqi;
        for(unsigned int i=0; i<_size; ++i)
        {
            T tmp = q[_dqi];
            if( tmp != init_val )
            {
                ret = tmp;
                break;
            }
            ++_dqi;
            _dqi = _dqi&(_size-1);
        }
        return ret;
    }
    public: size_t size()
    {
        return _size;
    }
};

#endif //_ULTRA_SIMPLE_QUEUE_