#ifndef _ULTRA_SIMPLE_POOL_
#define _ULTRA_SIMPLE_POOL_

template<typename T> class USPool
{
    private: bool pool_usage[];
    private: T pool[];
    private: int len;
   public: USPool(T init, int _size)
    {
        pool_usage = new bool[_size];
        pool = new pool[_size];
        len = _size;
        for(int i=0; i<len; ++i)
        {
            pool_usage[i] = false;
            pool[i] = init;
        }
    }
    public: ~USPool()
    {
        delete[] pool;
        pool = NULL;
        delete[] pool_usage;
        pool_usage = NULL;
    }
    public: T obtain(T unavail)
    {
        T ret = unavail;
        for(int i=0; i<len; ++i)
        {
            if(pool_usage[i] == false)
            {
                pool_usage[i] = true;
                ret = pool[i];
                break;
            }
        }
        return ret;
    }
    public: void release(T *released)
    {
        for(int i=0; i<len; ++i)
        {
            if(pool[i] == released)
            {
                pool_usage[i] = false;
            }
        }
    }
};

#endif //_ULTRA_SIMPLE_POOL_
