#ifndef _RTC8564NB_WRAPPER_H_
#define _RTC8564NB_WRAPPER_H_

#include "mbed.h"

#if defined (TARGET_KL25Z)

//RTC8564NB

class RTC_Handler
{
    I2C i2c;
    char read(char address);
    void write(char address, char value);
    RTC_Handler();
public:
    static RTC_Handler* getInstance();
    void setUTC(time_t t);
    void set(
        char y[3], char m[3], char d[3], char h[3], char min[3], char s[3]);
    time_t getUTC();
};

#elif defined(TARGET_TEENSY3_1)

// VT-200-F

class RTC_Handler
{
    RTC_Handler();
public:
    static RTC_Handler* getInstance();
    void setUTC(time_t t);
    time_t getUTC();
};

#endif

#define RTC_GET_UTC(T) T = RTC_Handler::getInstance()->getUTC()

#endif //_RTC8564NB_WRAPPER_H_
