#include "RTC_Handler.h"

static RTC_Handler *self = NULL;

RTC_Handler* RTC_Handler::getInstance()
{
    return self != NULL ? self : self = new RTC_Handler();
}

#if defined (TARGET_KL25Z)

#define RTC8564NB_ADR 0xA2

#define CONTROL1 0x00
#define CONTROL2 0x01
#define SECONDS 0x02
#define MINUTES 0x03
#define HOURS 0x04
#define DAYS 0x05
#define WEEKDAYS 0x06
#define MONTHS 0x07
#define YEARS 0x08
#define MINUTE_ALARM 0x09
#define HOUR_ALARM 0x0A
#define DAY_ALARM 0x0B
#define WEEKDAY_ALARM 0x0C
#define CLOCKOUT_FREQ 0x0D
#define TIMER_CONTROL 0x0E
#define TIMER 0x0F
#define _READ 0x01
#define JST_TO_UTC_DELTA (9*60*60)


RTC_Handler::RTC_Handler() : i2c(PTE0, PTE1)
{
}

char
RTC_Handler::read(char address)
{
    char value;
    i2c.start();
    i2c.write(RTC8564NB_ADR);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8564NB_ADR | _READ);
    value = i2c.read(0);
    i2c.stop();
    return value;
}

void
RTC_Handler::write(char address, char value)
{
    i2c.start();
    i2c.write(RTC8564NB_ADR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

void
RTC_Handler::set(char y[3], char m[3], char d[3], char h[3], char min[3], char s[3])
{
    write(CONTROL1, 0x20); //stop
    write(CONTROL2, 0x00);
    write(YEARS, ((y[0]-0x30)<<4)+(y[1]-0x30)); 
    write(MONTHS, ((m[0]-0x30)<<4)+(m[1]-0x30));
    write(DAYS, ((d[0]-0x30)<<4)+(d[1]-0x30));
    write(HOURS, ((h[0]-0x30)<<4)+(h[1]-0x30));
    write(MINUTES, ((min[0]-0x30)<<4)+(min[1]-0x30));
    write(SECONDS, ((s[0]-0x30)<<4)+(s[1]-0x30));
//    write(WEEKDAYS, week_val[0] - 0x30); //Sunday = "0", Monday = "1" ...
    write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    write(TIMER_CONTROL, 0x00);
    write(CONTROL1, 0x00); //start
    return;
}

void
RTC_Handler::setUTC(time_t t)
{
    struct tm *date;
    char str[32];
    memset(str,'\0',sizeof(str));
    //timer = time(NULL);
    //t -= JST_TO_UTC_DELTA; //make local time UTC
    date = localtime(&t);
    strftime(str, 255, "%y%m%d%H%M%S", date);
    //printf("%s\n", str);
    set(&str[0],&str[2],&str[4],&str[6],&str[8],&str[10]);
}

time_t
RTC_Handler::getUTC()
{
    int year = read(YEARS);
    int mon = read(MONTHS);
    int day = read(DAYS);
    int week = read(WEEKDAYS);
    int hour = read(HOURS);
    int min = read(MINUTES);
    int sec = read(SECONDS);
    
    year = ((year >> 4) & 0x03) * 10 + (year & 0x0F) + 2000;
    mon  = ((mon  >> 4) & 0x01) * 10 + (mon  & 0x0F);
    day  = ((day  >> 4) & 0x03) * 10 + (day  & 0x0F);
    hour = ((hour >> 4) & 0x03) * 10 + (hour & 0x0F);
    min  = ((min  >> 4) & 0x07) * 10 + (min  & 0x0F); 
    sec  = ((sec  >> 4) & 0x07) * 10 + (sec  & 0x0F);

    struct tm strtim;
    time_t ret;
    memset(( void * )&strtim , '\0' , sizeof( strtim ));
    strtim.tm_year = year-1900; /* 年[1900年から起算] */
    strtim.tm_mon = mon-1; /* 月[0-11] */
    strtim.tm_mday = day; /* 日[1-31] */
    strtim.tm_hour = hour ;/* 時[0-23] */
    strtim.tm_min = min ;/* 分[0-59] */
    strtim.tm_sec = sec; /* 秒[0-61]閏秒考慮 */

    /* 日付補完 */
    ret = mktime( &strtim );
    if( ret == -1 ) {
        printf( "mmktime error\n" );
    }
    
    return ret;
}
#elif defined (TARGET_TEENSY3_1)

RTC_Handler::RTC_Handler()
{
}

void
RTC_Handler::setUTC(time_t t)
{
    set_time(t);
}

time_t
RTC_Handler::getUTC()
{
    return time(NULL);
}

#endif
