#ifndef _MCU_RESET_REASON_HPP_
#define _MCU_RESET_REASON_HPP_

#include "mbed.h"

class MCUResetReason
{
    MCUResetReason();
    uint8_t SRS[2] ;
public:
    static MCUResetReason* ref();
    enum RESET_REASON
    {
        POWER_ON,
        EXTERNAL_PIN,
        WATCHDOG,
        LOSS_OF_LOCK,
        LOSS_OF_CLOCK,
        LOW_VOLTAGE_DETECT,
        LOW_LEAKAGE_WAKEUP,
        STOP_MODE_ACK_ERROR,
        MDM_AP_SYSTEM_RESET_REQUEST,
        SOFTWARE,
        CORE_LOCKUP,
        SIZE
    };
    static const char *str_reset_reason[SIZE];
    RESET_REASON getResetReason(void);
    const char *getResetReasonStr();
    void clearFlag();
};

#endif //#ifndef _MCU_RESET_REASON_HPP_