#ifndef _MARUSOL_DEBUG_IO_HPP_
#define _MARUSOL_DEBUG_IO_HPP_

#if defined (TARGET_TEENSY3_1)
    #include "USBSerial.h"
#else
    #include "mbed.h"
#endif

#include "Preferences.hpp"

#define SERIAL_PRINT_DBG_ON
#ifdef  SERIAL_PRINT_DBG_ON
    #define SERIAL_PRINT_DBG(...)  (DebugIO::debugIO->printf(__VA_ARGS__))
    #define SERIAL_PRINT_DBG_FUNCNAME() (DebugIO::debugIO->printf("%s,%d,%s\n",__FILE__,__LINE__,__PRETTY_FUNCTION__))
#else
    #define SERIAL_PRINT_DBG(...)
    #define SERIAL_PRINT_DBG_FUNCNAME()
#endif //SERIAL_PRINT_DBG_ON

//#define SERIAL_PRINT_DBG_ASR_ON
#ifdef  SERIAL_PRINT_DBG_ASR_ON
    #define SERIAL_PRINT_DBG_ASR(...)  (DebugIO::debugIO->printf(__VA_ARGS__))
#else
    #define SERIAL_PRINT_DBG_ASR(...)
#endif //SERIAL_PRINT_DBG_ASR_ON

template<typename A> struct template_debug_io
{
#if defined (TARGET_KL25Z)
    static Serial *debugIO;
#elif defined (TARGET_TEENSY3_1)
    static USBSerial *debugIO;
#endif
};

struct DebugIO : public template_debug_io<DebugIO>
{
    static void init()
    {
#if defined(SERIAL_PRINT_DBG_ON) || defined(SERIAL_PRINT_DBG_ASR_ON)
    #if defined (TARGET_KL25Z)
        debugIO = new Serial(USBTX, USBRX);
        debugIO->baud(PINS::UART::BAUD_RATE);
    #elif defined (TARGET_TEENSY3_1)
        debugIO = new USBSerial();
    #endif
#endif
    }
    static void test()
    {
        SERIAL_PRINT_DBG("%s\n","dbg");
        SERIAL_PRINT_DBG_FUNCNAME();
        SERIAL_PRINT_DBG_ASR("%s\n","dbg asr");
        SERIAL_PRINT_DBG("baud rate:%ld\n",PINS::UART::BAUD_RATE);
    }
};

#if defined (TARGET_KL25Z)
    template<> Serial *template_debug_io<DebugIO>::debugIO = NULL;
#elif defined (TARGET_TEENSY3_1)
    template<> USBSerial *template_debug_io<DebugIO>::debugIO = NULL;
#endif

#endif //_MARUSOL_DEBUG_IO_HPP_