#include "CheckSum.h"

uint32_t *CheckSum::table = NULL;

CheckSum::CheckSum()
{
    reset();
    reset_table();
}

void
CheckSum::reset()
{
    checkSum = 0xFFFFFFFF;
}

void
CheckSum::reset_table()
{
   if(table==NULL)
    {
        table = new uint32_t[256];
        for (uint32_t i = 0; i < 256; i++)
        {
            uint32_t c = i;
            for (int j = 0; j < 8; j++)
            {
                c = (c & 1) ? (0xEDB88320 ^ (c >> 1)) : (c >> 1);
            }
            table[i] = c;
        }
    }
}

void
CheckSum::calc(uint8_t *buf, size_t len)
{
    for (size_t i = 0; i < len; i++)
    {
        checkSum = table[(checkSum ^ buf[i]) & 0xFF] ^ (checkSum >> 8);
    }
}

//CheckSum::CheckSumCRC32
PREFERENCES::_crc32
CheckSum::get()
{
//    CheckSumCRC32 crc32;
    PREFERENCES::_crc32 ret;
    ret.ui32 = checkSum ^ 0xFFFFFFFF;
    return ret; 
}
